/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.eapi.jei;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import wile.wilescollection.ModConfig;
import wile.wilescollection.blocks.ExtCraftingTable;
import wile.wilescollection.libmc.Auxiliaries;
import wile.wilescollection.libmc.Registries;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation(Auxiliaries.modid(), "jei_plugin_uid");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        if (!ModConfig.isOptedOut(Registries.getBlock("crafting_table"))) {
            try {
                registration.addRecipeTransferHandler(ExtCraftingTable.CraftingTableUiContainer.class, null, RecipeTypes.CRAFTING, 1, 9, 10, 54);
            }
            catch (Throwable e) {
                Auxiliaries.logger().warn("Exception in JEI crafting table handler registration: '" + e.getMessage() + "'.");
            }
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        HashSet<Item> blacklisted = new HashSet<Item>();
        for (Block block : Registries.getRegisteredBlocks()) {
            if (!ModConfig.isOptedOut(block) || !Auxiliaries.getResourceLocation(block.m_5456_()).m_135815_().equals(Auxiliaries.getResourceLocation(block).m_135815_())) continue;
            blacklisted.add(block.m_5456_());
        }
        for (Item item : Registries.getRegisteredItems()) {
            if (!ModConfig.isOptedOut(item) || item instanceof BlockItem) continue;
            blacklisted.add(item);
        }
        if (!blacklisted.isEmpty()) {
            List blacklist = blacklisted.stream().map(ItemStack::new).collect(Collectors.toList());
            try {
                jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, blacklist);
            }
            catch (Exception exception) {
                Auxiliaries.logger().warn("Exception in JEI opt-out processing: '" + exception.getMessage() + "', skipping further JEI optout processing.");
            }
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (!ModConfig.isOptedOut(Registries.getBlock("crafting_table"))) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)Registries.getBlock("crafting_table")), new RecipeType[]{RecipeTypes.CRAFTING});
        }
    }
}

