/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.items;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.wilescollection.libmc.Auxiliaries;

public class Armors {
    public static long CFG_DEFAULT = 0L;
    public static long CFG_MAKES_PIGLINS_NEUTRAL = 0x100000000L;

    public static class BootsArmorItem
    extends ModArmorItem {
        public BootsArmorItem(long config, ArmorMaterial material, Item.Properties properties) {
            super(config, material, ArmorItem.Type.BOOTS, properties);
        }
    }

    public static class LeggingsArmorItem
    extends ModArmorItem {
        public LeggingsArmorItem(long config, ArmorMaterial material, Item.Properties properties) {
            super(config, material, ArmorItem.Type.LEGGINGS, properties);
        }
    }

    public static class ChestPlateArmorItem
    extends ModArmorItem {
        public ChestPlateArmorItem(long config, ArmorMaterial material, Item.Properties properties) {
            super(config, material, ArmorItem.Type.CHESTPLATE, properties);
        }
    }

    public static class HelmetArmorItem
    extends ModArmorItem {
        public HelmetArmorItem(long config, ArmorMaterial material, Item.Properties properties) {
            super(config, material, ArmorItem.Type.HELMET, properties);
        }
    }

    public static abstract class ModArmorItem
    extends ArmorItem {
        protected Map<Attribute, AttributeModifier> modifiers_ = new HashMap<Attribute, AttributeModifier>();
        protected final long armor_config;

        public ModArmorItem(long config, ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
            super(material, type, properties);
            this.armor_config = config;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
            Auxiliaries.Tooltip.addInformation(stack, (BlockGetter)world, tooltip, flag, true);
        }

        public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
            Multimap modifiers = super.m_7167_(slot);
            return !modifiers.isEmpty() ? MultimapBuilder.hashKeys().hashSetValues().build(modifiers) : MultimapBuilder.hashKeys().hashSetValues().build();
        }

        protected AttributeModifier attributeModifier(Attribute attribute, Supplier<AttributeModifier> initializer) {
            AttributeModifier modifier = this.modifiers_.get(attribute);
            if (modifier != null) {
                return modifier;
            }
            modifier = initializer.get();
            this.modifiers_.put(attribute, modifier);
            return modifier;
        }

        public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
            return (this.armor_config & CFG_MAKES_PIGLINS_NEUTRAL) != 0L;
        }

        public boolean m_5812_(ItemStack stack) {
            return false;
        }
    }
}

