/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import wile.wilescollection.items.ModItem;
import wile.wilescollection.libmc.Auxiliaries;
import wile.wilescollection.libmc.Inventories;
import wile.wilescollection.libmc.Overlay;
import wile.wilescollection.libmc.Registries;

public class BackfillWandItem
extends ModItem {
    private static Set<Item> blocks_spawnable_with_charges = new HashSet<Item>();
    private static int max_gap_filling_depth = 5;
    private static int max_charges_ = 4096;
    private static Map<Vec3i, Integer> gap_weights = Map.of(new Vec3i(1, 0, 0), 3, new Vec3i(0, 0, 1), 3, new Vec3i(-1, 0, 0), 3, new Vec3i(0, 0, -1), 3, new Vec3i(1, 0, 1), 2, new Vec3i(1, 0, -1), 2, new Vec3i(-1, 0, 1), 2, new Vec3i(-1, 0, -1), 2);

    public static void on_config(int max_charges) {
        max_charges_ = Mth.m_14045_((int)max_charges, (int)1, (int)65536);
        blocks_spawnable_with_charges.clear();
        blocks_spawnable_with_charges.add(Items.f_42329_);
        blocks_spawnable_with_charges.add(Items.f_41905_);
        blocks_spawnable_with_charges.add(Items.f_42594_);
        blocks_spawnable_with_charges.add(Items.f_42276_);
        blocks_spawnable_with_charges.add(Items.f_42170_);
        blocks_spawnable_with_charges.add(Items.f_151034_);
        blocks_spawnable_with_charges.add(Items.f_41832_);
        blocks_spawnable_with_charges.add(Items.f_151035_);
        blocks_spawnable_with_charges.add(Registries.getItem("patchy_stone"));
    }

    public BackfillWandItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)Math.max(0, max_charges_ - this.getDamage(stack)) / (float)max_charges_);
    }

    public int m_142159_(ItemStack stack) {
        return 2990071;
    }

    public boolean m_41465_() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return max_charges_;
    }

    public int getDamage(ItemStack stack) {
        return !stack.m_41782_() ? 0 : stack.m_41783_().m_128451_("uses");
    }

    public void setDamage(ItemStack stack, int damage) {
        stack.m_41784_().m_128405_("uses", Math.max(0, damage));
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 120;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer splayer = (ServerPlayer)player;
            if (hand != InteractionHand.MAIN_HAND) {
                Overlay.show(player, Auxiliaries.localizable("item." + Auxiliaries.modid() + ".wand_of_backfilling.fail.notmainhand"));
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            ItemStack placememt_stack = this.getSelectedPlacementItem(splayer);
            if (placememt_stack.m_41619_()) {
                Overlay.show(player, Auxiliaries.localizable("item." + Auxiliaries.modid() + ".wand_of_backfilling.fail.noblocks"));
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (this.getSelectedPlacementBlock(splayer).m_41619_()) {
                Overlay.show(player, (Component)Auxiliaries.localizable("item." + Auxiliaries.modid() + ".wand_of_backfilling.fail.cantplace", placememt_stack.m_41720_().m_7626_(placememt_stack)));
                return InteractionResultHolder.m_19100_((Object)stack);
            }
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
    }

    public void m_5929_(Level world, LivingEntity entity, ItemStack wand, int count) {
        ItemStack stack;
        if (!wand.m_150930_((Item)this)) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BlockHitResult bh = Item.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        Direction facing = bh.m_82434_();
        BlockPos pos = bh.m_82425_().m_121945_(facing);
        if (!world.m_8055_(pos).m_60713_(Blocks.f_49990_) && facing == Direction.UP) {
            pos = pos.m_121945_(facing.m_122424_());
        }
        if (this.backfill((ServerLevel)world, pos, player, stack = this.getSelectedPlacementBlock(player), !world.m_8055_(pos).m_60819_().m_76178_(), player.m_20161_())) {
            this.consumeStack(stack, player);
        }
    }

    private ItemStack getSelectedPlacementItem(ServerPlayer player) {
        int sel_index = player.m_150109_().f_35977_ + 1;
        if (!Inventory.m_36045_((int)sel_index)) {
            return ItemStack.f_41583_;
        }
        return player.m_150109_().m_8020_(sel_index);
    }

    private ItemStack getSelectedPlacementBlock(ServerPlayer player) {
        ItemStack ref_stack = this.getSelectedPlacementItem(player);
        if (ref_stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        Item item = ref_stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return ItemStack.f_41583_;
        }
        BlockItem bi = (BlockItem)item;
        if (bi.m_40614_() instanceof EntityBlock) {
            return ItemStack.f_41583_;
        }
        BlockState state = bi.m_40614_().m_49966_();
        if (state.m_204336_(BlockTags.f_13050_) || state.m_204336_(BlockTags.f_13104_) || state.m_204336_(BlockTags.f_13041_)) {
            return ItemStack.f_41583_;
        }
        return ref_stack;
    }

    private boolean isReplacable(ServerLevel world, BlockPos pos, boolean allow_fluid) {
        if (world.m_7702_(pos) != null) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_278411_)) {
            return true;
        }
        return allow_fluid && state.m_60713_(Blocks.f_49990_);
    }

    private boolean isFullSolidBlock(ServerLevel world, BlockPos pos) {
        return world.m_8055_(pos).m_60838_((BlockGetter)world, pos);
    }

    private boolean isTopSolidBlock(ServerLevel world, BlockPos pos) {
        return world.m_8055_(pos).m_60783_((BlockGetter)world, pos, Direction.UP);
    }

    private void consumeStack(ItemStack stack, ServerPlayer player) {
        if (stack.m_41613_() > 1) {
            stack.m_41774_(1);
            return;
        }
        int sel_index = player.m_150109_().f_35977_ + 1;
        Optional available = Inventories.InventoryRange.fromPlayerInventory((Player)player).find((i, s) -> {
            if (i == sel_index || !Inventories.areItemStacksIdentical(s, stack)) {
                return Optional.empty();
            }
            return Optional.of(s);
        });
        if (available.isPresent()) {
            ((ItemStack)available.get()).m_41774_(1);
            return;
        }
        ItemStack wand = player.m_21205_();
        if (blocks_spawnable_with_charges.contains(stack.m_41720_())) {
            int dmg = this.getDamage(wand);
            if (dmg < max_charges_) {
                this.setDamage(wand, dmg + 1);
                return;
            }
            if (player.m_7500_()) {
                this.setDamage(wand, 0);
                return;
            }
        }
        stack.m_41774_(1);
    }

    private boolean placeBlock(ServerLevel world, BlockPos pos, ItemStack stack) {
        Item item;
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BlockItem)) {
            return false;
        }
        BlockItem block_item = (BlockItem)item;
        if (!this.isReplacable(world, pos, true)) {
            return false;
        }
        if (!world.m_6249_((Entity)null, new AABB(pos), e -> !(e instanceof ItemEntity)).isEmpty()) {
            return false;
        }
        BlockState state = block_item.m_40614_().m_49966_();
        if (!world.m_7731_(pos, state, 10)) {
            return false;
        }
        world.m_5594_(null, pos, state.m_60827_().m_56777_(), SoundSource.BLOCKS, 0.7f, 1.1f);
        return true;
    }

    private int getGapWeight(ServerLevel world, BlockPos pos, boolean allow_fluid) {
        if (!this.isReplacable(world, pos, allow_fluid)) {
            return 0;
        }
        if (!this.isTopSolidBlock(world, pos.m_7495_())) {
            return 0;
        }
        return gap_weights.entrySet().stream().mapToInt(e -> this.isFullSolidBlock(world, pos.m_121955_((Vec3i)e.getKey())) ? (Integer)e.getValue() : 0).sum();
    }

    private List<BlockPos> getHorizontalPositions(BlockPos pos, int radius) {
        if (radius <= 0) {
            return List.of(pos);
        }
        ArrayList<BlockPos> rng_positions = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos.m_121940_((BlockPos)pos.m_7918_(-radius, 0, -radius), (BlockPos)pos.m_7918_(radius, 0, radius)).forEach(p -> rng_positions.add(new BlockPos((Vec3i)p)));
        Collections.shuffle(rng_positions);
        return rng_positions;
    }

    private boolean isBehindPlayer(ServerLevel world, BlockPos pos, ServerPlayer player) {
        Vec3 placement_angle = Vec3.m_82512_((Vec3i)pos).m_82546_(player.m_20182_()).m_193103_(Direction.Axis.Y, 0.0).m_82541_();
        Vec3 look_angle = player.m_20154_().m_193103_(Direction.Axis.Y, 0.0);
        double da = Math.acos(look_angle.m_82526_(placement_angle)) * 180.0 / Math.PI;
        return da >= 110.0;
    }

    private boolean backfill(ServerLevel world, BlockPos from_pos, ServerPlayer player, ItemStack stack, boolean allow_fluid, boolean only_below) {
        int min_depth;
        int min_weight = 5;
        int n = min_depth = only_below ? 1 : 0;
        if (this.getGapWeight(world, from_pos, allow_fluid) >= 5 && this.placeBlock(world, from_pos, stack)) {
            return true;
        }
        for (int depth = max_gap_filling_depth; depth >= min_depth; --depth) {
            BlockPos ref_pos = from_pos.m_6625_(depth);
            for (BlockPos r_pos : this.getHorizontalPositions(ref_pos, 1)) {
                for (BlockPos fill_pos : this.getHorizontalPositions(r_pos, 1)) {
                    int weight;
                    double ds = ref_pos.m_203198_((double)fill_pos.m_123341_(), (double)ref_pos.m_123342_(), (double)fill_pos.m_123343_());
                    if (ds > 3.0 || (weight = this.getGapWeight(world, fill_pos, allow_fluid)) <= 0 || weight <= 5 || this.isBehindPlayer(world, fill_pos, player) || !this.placeBlock(world, fill_pos, stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

