/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.items;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import wile.wilescollection.detail.ModRenderers;
import wile.wilescollection.items.ModItem;
import wile.wilescollection.libmc.Auxiliaries;
import wile.wilescollection.libmc.Registries;

public class ProspectingDowserItem
extends ModItem {
    private static int search_range = 12;

    public ProspectingDowserItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new ModRenderers.ProspectingDowserIster();
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (!stack.m_41782_()) {
            return;
        }
        ResourceLocation rl = ResourceLocation.m_135820_((String)stack.m_41783_().m_128461_("target"));
        if (rl == null) {
            return;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(rl);
        if (block == null) {
            return;
        }
        tooltip.add((Component)Auxiliaries.localizable("item.wilescollection.prospecting_dowser.status", block.m_49954_()));
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public boolean m_41475_() {
        return true;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return false;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean isSelected) {
        Vec3 dist_vec;
        double dist;
        BlockPos pos_found;
        ResourceLocation rl;
        if (!world.m_5776_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        TagKey<Block> searches = Registries.getBlockTagKey("prospectible");
        if (isSelected && searches != null && (rl = ResourceLocation.m_135820_((String)tag.m_128461_("target"))) != null && (pos_found = this.blockSearch(world, entity.m_20183_(), searches)) != null && (dist = ((double)search_range - (dist_vec = entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0).m_82546_(Vec3.m_82512_((Vec3i)pos_found))).m_82553_()) / (double)search_range) > 0.01) {
            double look = entity.m_20154_().m_82546_(dist_vec.m_82541_()).m_82556_() * 2.0;
            int intensity = (int)Mth.m_14008_((double)(dist * dist * 4.0 + look * Math.min(dist + 0.5, 1.0)), (double)0.0, (double)15.0);
            tag.m_128405_("rotation", (tag.m_128451_("rotation") + intensity * 8) % 360);
            tag.m_128359_("target", Auxiliaries.getResourceLocation(world.m_8055_(pos_found).m_60734_()).toString());
            return;
        }
        tag.m_128473_("rotation");
        tag.m_128473_("target");
    }

    @Nullable
    private BlockPos blockSearchPN(Level world, BlockPos origin, TagKey<Block> match_block, int x, int y, int z) {
        if (world.m_8055_(origin.m_7918_(x, y, z)).m_204336_(match_block)) {
            return origin.m_7918_(x, y, z);
        }
        if (world.m_8055_(origin.m_7918_(-x, y, z)).m_204336_(match_block)) {
            return origin.m_7918_(-x, y, z);
        }
        if (world.m_8055_(origin.m_7918_(x, -y, z)).m_204336_(match_block)) {
            return origin.m_7918_(x, -y, z);
        }
        if (world.m_8055_(origin.m_7918_(-x, -y, z)).m_204336_(match_block)) {
            return origin.m_7918_(-x, -y, z);
        }
        if (world.m_8055_(origin.m_7918_(x, y, -z)).m_204336_(match_block)) {
            return origin.m_7918_(x, y, -z);
        }
        if (world.m_8055_(origin.m_7918_(-x, y, -z)).m_204336_(match_block)) {
            return origin.m_7918_(-x, y, -z);
        }
        if (world.m_8055_(origin.m_7918_(x, -y, -z)).m_204336_(match_block)) {
            return origin.m_7918_(x, -y, -z);
        }
        if (world.m_8055_(origin.m_7918_(-x, -y, -z)).m_204336_(match_block)) {
            return origin.m_7918_(-x, -y, -z);
        }
        return null;
    }

    @Nullable
    private BlockPos blockSearch(Level world, BlockPos origin, TagKey<Block> match_block) {
        for (int y = 0; y < search_range; ++y) {
            for (int x = 0; x < search_range; ++x) {
                for (int z = 0; z < search_range; ++z) {
                    BlockPos p = this.blockSearchPN(world, origin, match_block, x, y, z);
                    if (p == null) continue;
                    return p;
                }
            }
        }
        return null;
    }
}

