/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.items;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;
import wile.wilescollection.libmc.Auxiliaries;
import wile.wilescollection.libmc.ExtendedShapelessRecipe;
import wile.wilescollection.libmc.TreeCutting;

public class RediaToolItem
extends AxeItem
implements ExtendedShapelessRecipe.IRepairableToolItem {
    private static int enchantability = 10;
    private static int max_item_damage = 3000;
    private static int initial_item_damage_percent = 100;
    private static final boolean with_torch_placing = true;
    private static boolean with_hoeing = true;
    private static boolean with_tree_felling = true;
    private static final boolean with_shearing = true;
    private static boolean with_safe_attacking = true;
    private static final int max_tree_felling_blocks_to_break = 128;

    public static void on_config(boolean without_redia_torchplacing, boolean without_redia_hoeing, boolean without_redia_tree_chopping, boolean without_safe_attacking, int durability, int redia_tool_initial_durability_percent, int tool_enchantability) {
        boolean with_torch_placing = !without_redia_torchplacing;
        with_hoeing = !without_redia_hoeing;
        with_tree_felling = !without_redia_tree_chopping;
        max_item_damage = Mth.m_14045_((int)durability, (int)750, (int)4000);
        initial_item_damage_percent = Mth.m_14045_((int)redia_tool_initial_durability_percent, (int)1, (int)100);
        with_safe_attacking = !without_safe_attacking;
        enchantability = Mth.m_14045_((int)tool_enchantability, (int)5, (int)25);
        Auxiliaries.logInfo("REDIA tool config: " + (with_torch_placing ? "" : "no-") + "torch-placing, " + (with_hoeing ? "" : "no-") + "hoeing, " + (with_tree_felling ? "" : "no-") + "tree-felling, " + (with_safe_attacking ? "" : "no-") + "safe-attack, durability:" + max_item_damage + ", initial-durability:" + redia_tool_initial_durability_percent);
    }

    public RediaToolItem(Item.Properties properties) {
        super((Tier)Tiers.DIAMOND, 5.0f, -3.0f, properties.m_41487_(1).m_41497_(Rarity.UNCOMMON).m_41499_(max_item_damage));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        Auxiliaries.Tooltip.addInformation(stack, (BlockGetter)world, tooltip, flag, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public int m_6473_() {
        return enchantability;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return super.m_6832_(toRepair, repair);
    }

    public boolean m_41465_() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return max_item_damage;
    }

    public boolean m_8096_(BlockState state) {
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return true;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44987_) {
            return true;
        }
        if (enchantment == Enchantments.f_44984_) {
            return true;
        }
        if (enchantment == Enchantments.f_44980_) {
            return true;
        }
        if (enchantment == Enchantments.f_44982_) {
            return true;
        }
        if (enchantment == Enchantments.f_44977_) {
            return true;
        }
        if (enchantment == Enchantments.f_44981_) {
            return true;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        if (stack.m_41773_() != 0) {
            return;
        }
        if (stack.m_41782_() && stack.m_41783_().m_128431_().stream().anyMatch(e -> !e.equals("Damage"))) {
            return;
        }
        stack.m_41721_(this.absoluteDmg(initial_item_damage_percent));
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return super.m_7579_(stack, target, attacker);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        ZombifiedPiglin piglin;
        TamableAnimal animal;
        if (!with_safe_attacking) {
            return false;
        }
        if (entity instanceof Villager) {
            return true;
        }
        if (entity instanceof TamableAnimal && (animal = (TamableAnimal)entity).m_21824_() && animal.m_21830_((LivingEntity)player)) {
            return true;
        }
        if (entity instanceof ZombifiedPiglin && (piglin = (ZombifiedPiglin)entity).m_5448_() == null) {
            return true;
        }
        if (player.m_9236_().f_46443_) {
            return false;
        }
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult rv;
        Direction facing = context.m_43719_();
        InteractionHand hand = context.m_43724_();
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Vec3 hitvec = context.m_43720_();
        if (context.m_43723_().m_6144_()) {
            rv = this.tryPlantSnipping(player, world, pos, hand, facing, hitvec);
            if (rv != InteractionResult.PASS) {
                return rv;
            }
            if (facing == Direction.UP) {
                rv = this.tryDigOver(player, world, pos, hand, facing, hitvec);
                if (rv != InteractionResult.PASS) {
                    return rv;
                }
            } else if (facing.m_122434_().m_122479_()) {
                rv = this.tryTorchPlacing(context);
                if (rv != InteractionResult.PASS) {
                    return rv;
                }
            } else {
                rv = super.m_6225_(context);
            }
        } else {
            rv = this.tryTorchPlacing(context);
            if (rv != InteractionResult.PASS) {
                return rv;
            }
        }
        return rv;
    }

    public boolean m_6813_(ItemStack tool, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (world.f_46443_ || !(entity instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        if (state.m_60800_((BlockGetter)world, pos) > 0.5f || world.m_213780_().m_188500_() > 0.67) {
            tool.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        }
        if (with_tree_felling && player.m_6144_()) {
            this.tryTreeFelling(world, state, pos, (LivingEntity)player);
        }
        return true;
    }

    public InteractionResult m_6880_(ItemStack tool, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity.m_9236_().f_46443_) {
            return InteractionResult.PASS;
        }
        return this.tryEntityShearing(tool, player, entity, hand);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.f_40980_;
    }

    @Override
    public ItemStack onShapelessRecipeRepaired(ItemStack stack, int previousDamage, int repairedDamage) {
        return stack;
    }

    private int absoluteDmg(int dmg) {
        return max_item_damage * (100 - Mth.m_14045_((int)dmg, (int)1, (int)100)) / 100;
    }

    private InteractionResult tryEntityShearing(ItemStack tool, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity.m_9236_().f_46443_ || !(entity instanceof IForgeShearable)) {
            return InteractionResult.PASS;
        }
        IForgeShearable target = (IForgeShearable)entity;
        BlockPos pos = new BlockPos((Vec3i)entity.m_20183_());
        if (target.isShearable(tool, entity.m_9236_(), pos)) {
            List drops = target.onSheared(player, tool, entity.m_9236_(), pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool));
            Random rand = new Random();
            drops.forEach(d -> {
                ItemEntity ent = entity.m_5552_(d, 1.0f);
                ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            });
            tool.m_41622_(1, entity, e -> e.m_21190_(hand));
            player.m_9236_().m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 0.8f, 1.1f);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult tryPlantSnipping(Player player, Level world, BlockPos pos, InteractionHand hand, Direction facing, Vec3 hitvec) {
        ItemStack tool = player.m_21120_(hand);
        if (tool.m_41720_() != this) {
            return InteractionResult.PASS;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (!state.m_204336_(BlockTags.f_13035_) && block != Blocks.f_50033_ && block != Blocks.f_50034_ && block != Blocks.f_50035_ && block != Blocks.f_50036_ && block != Blocks.f_50191_ && block != Blocks.f_50267_ && !state.m_204336_(BlockTags.f_13089_)) {
            return InteractionResult.PASS;
        }
        ItemEntity ie = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)block.m_5456_()));
        ie.m_32060_();
        world.m_7967_((Entity)ie);
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        tool.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        world.m_5594_(player, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 0.8f, 1.1f);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult tryTorchPlacing(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != Blocks.f_50081_.m_5456_()) continue;
            ItemStack tool = player.m_21120_(hand);
            player.m_21008_(hand, stack);
            UseOnContext torch_context = new UseOnContext(context.m_43723_(), context.m_43724_(), new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_()));
            InteractionResult r = stack.m_41720_().m_6225_(torch_context);
            player.m_21008_(hand, tool);
            return r;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tryDigOver(Player player, Level world, BlockPos pos, InteractionHand hand, Direction facing, Vec3 hitvec) {
        BlockState state;
        if (!with_hoeing) {
            return InteractionResult.PASS;
        }
        if (world.m_7702_(pos) != null) {
            return InteractionResult.PASS;
        }
        BlockState replaced = state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof GrassBlock || block == Blocks.f_50493_) {
            replaced = Blocks.f_50093_.m_49966_();
        } else if (block instanceof FarmBlock) {
            replaced = Blocks.f_50546_.m_49966_();
        } else if (block == Blocks.f_50546_) {
            replaced = Blocks.f_152481_.m_49966_();
        } else if (block instanceof DirtPathBlock) {
            replaced = Blocks.f_50493_.m_49966_();
        }
        if (replaced != state) {
            world.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 0.8f, 1.1f);
            if (!world.f_46443_) {
                world.m_7731_(pos, replaced, 3);
                ItemStack stack = player.m_21120_(hand);
                if (stack.m_41720_() == this) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean tryTreeFelling(Level world, BlockState state, BlockPos pos, LivingEntity player) {
        if (!with_tree_felling || !TreeCutting.canChop(state)) {
            return false;
        }
        BlockState state_below = world.m_8055_(pos.m_7495_());
        if (state_below != null && state.m_60713_(state_below.m_60734_())) {
            return false;
        }
        return TreeCutting.chopTree(player.m_9236_(), state, pos, 128, true) > 0;
    }
}

