/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.items;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import wile.wilescollection.detail.ModRenderers;
import wile.wilescollection.items.ModItem;
import wile.wilescollection.libmc.Auxiliaries;
import wile.wilescollection.libmc.Overlay;

public class TrackerItem
extends ModItem {
    private static final ConcurrentHashMap<Integer, Tuple<Integer, Integer>> tracker_angles = new ConcurrentHashMap();

    public TrackerItem(Item.Properties properties) {
        super(properties.m_41487_(1).setNoRepair());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new ModRenderers.TrackerIster();
            }
        });
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (Auxiliaries.Tooltip.helpCondition() || Auxiliaries.Tooltip.extendedTipCondition()) {
            super.m_7373_(stack, world, tooltip, flag);
            return;
        }
        CompoundTag nbt = stack.m_41737_("trackerdata");
        if (nbt == null) {
            return;
        }
        int distance = -1;
        String dimension_name = "";
        Object text = "";
        if (nbt.m_128441_("target")) {
            BlockPos target_pos = BlockPos.m_122022_((long)nbt.m_128454_("target"));
            if (nbt.m_128441_("playerpos")) {
                distance = (int)Math.sqrt(BlockPos.m_122022_((long)nbt.m_128454_("playerpos")).m_123331_((Vec3i)target_pos));
            }
        } else {
            dimension_name = nbt.m_128461_("dimensionid");
        }
        if (nbt.m_128441_("location")) {
            BlockPos pos = BlockPos.m_122022_((long)nbt.m_128454_("location"));
            text = "[" + pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_() + "]";
            text = Auxiliaries.localizable("item." + Auxiliaries.modid() + ".tracking_compass.tip.target.location", text).getString();
        } else if (nbt.m_128441_("entityname")) {
            text = nbt.m_128461_("entityname");
            if (((String)text).isEmpty()) {
                return;
            }
            text = Auxiliaries.localizable("item." + Auxiliaries.modid() + ".tracking_compass.tip.target.entity", text).getString();
        }
        if (distance >= 0) {
            if (distance > 0) {
                text = (String)text + Auxiliaries.localizable("item." + Auxiliaries.modid() + ".tracking_compass.tip.target.distance", distance).getString();
            }
        } else if (!dimension_name.isEmpty()) {
            text = (String)text + Auxiliaries.localizable("item." + Auxiliaries.modid() + ".tracking_compass.tip.dimension." + dimension_name, distance).getString();
        }
        tooltip.add((Component)Component.m_237115_((String)text));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (world.m_5776_()) {
            return InteractionResult.CONSUME;
        }
        if (!this.checkOverwrite(context.m_43722_(), context.m_43723_())) {
            return InteractionResult.FAIL;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128356_("location", context.m_8083_().m_121878_());
        nbt.m_128405_("dimension", this.dimensionIdentifier(world));
        nbt.m_128359_("dimensionid", this.dimensionName(world));
        context.m_43722_().m_41700_("trackerdata", (Tag)nbt);
        Overlay.show(context.m_43723_(), Auxiliaries.localizable("item." + Auxiliaries.modid() + ".tracking_compass.msg.locationset"));
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (player.m_20193_().m_5776_()) {
            return InteractionResult.CONSUME;
        }
        if (!this.checkOverwrite(player.m_21120_(hand), player)) {
            return InteractionResult.FAIL;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("entity", target.m_20148_());
        nbt.m_128359_("entityname", target.m_5446_().getString());
        player.m_21120_(hand).m_41700_("trackerdata", (Tag)nbt);
        Overlay.show(player, (Component)Auxiliaries.localizable("item." + Auxiliaries.modid() + ".tracking_compass.msg.entityset", target.m_5446_()));
        return InteractionResult.SUCCESS;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof Player)) {
            return;
        }
        if (world instanceof ServerLevel) {
            this.serverTick(stack, (ServerLevel)world, (Player)entity, slot, selected);
        } else {
            this.clientTick(stack, world, (Player)entity, slot, selected);
        }
    }

    private boolean checkOverwrite(ItemStack stack, Player player) {
        CompoundTag nbt = stack.m_41737_("trackerdata");
        if (nbt == null || nbt.m_128456_()) {
            return true;
        }
        if (player.m_20154_().f_82480_ < -0.98) {
            stack.m_41751_(null);
            Overlay.show(player, Auxiliaries.localizable("item." + Auxiliaries.modid() + ".tracking_compass.hint.cleared"));
        } else {
            Overlay.show(player, Auxiliaries.localizable("item." + Auxiliaries.modid() + ".tracking_compass.hint.clearfirst"));
        }
        return false;
    }

    public static Optional<Tuple<Integer, Integer>> getUiAngles(ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("trackerdata");
        if (nbt == null || !nbt.m_128441_("id")) {
            return Optional.empty();
        }
        Tuple rot = tracker_angles.getOrDefault(nbt.m_128451_("id"), null);
        return rot == null ? Optional.empty() : Optional.of(rot);
    }

    private int dimensionIdentifier(Level world) {
        return this.dimensionName(world).hashCode();
    }

    private String dimensionName(Level world) {
        if (world.m_46472_() == Level.f_46428_) {
            return "overworld";
        }
        if (world.m_46472_() == Level.f_46429_) {
            return "nether";
        }
        if (world.m_46472_() == Level.f_46430_) {
            return "end";
        }
        return "other";
    }

    private void clientTick(ItemStack stack, Level world, Player player, int slot, boolean selected) {
        CompoundTag nbt = stack.m_41737_("trackerdata");
        if (nbt == null || nbt.m_128456_() || !nbt.m_128441_("id")) {
            return;
        }
        if (!nbt.m_128441_("target")) {
            tracker_angles.remove(nbt.m_128451_("id"));
            return;
        }
        BlockPos pos = BlockPos.m_122022_((long)nbt.m_128454_("target"));
        Vec3 gdv = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_82546_(player.m_20182_());
        double dsq = gdv.m_82556_();
        if (dsq < 0.3) {
            return;
        }
        double xz_distance = new Vec3(gdv.f_82479_, 0.0, gdv.f_82481_).m_82553_();
        double y_distance = Math.abs(gdv.f_82480_);
        gdv = gdv.m_82541_();
        Vec3 ldv = player.m_20154_();
        double ry = (Math.atan2(ldv.f_82481_, ldv.f_82479_) - Math.atan2(gdv.f_82481_, gdv.f_82479_)) * 180.0 / Math.PI;
        double rx = y_distance + 5.0 > xz_distance ? (Math.acos(ldv.f_82480_) - Math.acos(gdv.f_82480_)) * 180.0 / Math.PI : 0.0;
        double inc = 10.0;
        if (rx > 180.0) {
            rx -= 360.0;
        }
        if (ry > 180.0) {
            ry -= 360.0;
        }
        if (Math.abs(rx) < 30.0) {
            rx = 0.0;
        }
        Vec3 p = player.m_20182_();
        nbt.m_128356_("playerpos", new BlockPos((int)p.f_82479_, (int)p.f_82480_, (int)p.f_82481_).m_121878_());
        tracker_angles.put(nbt.m_128451_("id"), (Tuple<Integer, Integer>)new Tuple((Object)((int)rx), (Object)((int)ry)));
    }

    private void serverTick(ItemStack stack, ServerLevel world, Player player, int slot, boolean selected) {
        if ((world.m_46467_() & 7L) != 0L) {
            return;
        }
        if (stack.m_41783_() == null || stack.m_41783_().m_128456_()) {
            return;
        }
        boolean changed = false;
        CompoundTag nbt = stack.m_41698_("trackerdata");
        if (!nbt.m_128441_("id")) {
            nbt.m_128405_("id", world.m_213780_().m_188502_());
            if (tracker_angles.size() > 128) {
                tracker_angles.clear();
            }
        }
        if (nbt.m_128441_("location")) {
            long pos = nbt.m_128454_("location");
            long uipos = nbt.m_128454_("target");
            if ((long)this.dimensionIdentifier((Level)world) != nbt.m_128454_("dimension")) {
                if (nbt.m_128441_("target")) {
                    nbt.m_128473_("target");
                    changed = true;
                }
            } else if (pos != uipos) {
                nbt.m_128356_("target", pos);
                changed = true;
            }
        } else if (nbt.m_128441_("entity")) {
            Entity target = world.m_8791_(nbt.m_128342_("entity"));
            if (target == null || target.m_20193_() == null || this.dimensionIdentifier(target.m_20193_()) != this.dimensionIdentifier(player.m_20193_())) {
                if (nbt.m_128441_("target")) {
                    nbt.m_128473_("target");
                    changed = true;
                }
            } else {
                BlockPos uipos = BlockPos.m_122022_((long)nbt.m_128454_("target"));
                if (player.m_20280_(target) > 200.0) {
                    if (uipos.m_203193_((Position)target.m_20182_()) > 10.0) {
                        Vec3 p = target.m_20182_();
                        nbt.m_128356_("target", new BlockPos((int)p.f_82479_, (int)p.f_82480_, (int)p.f_82481_).m_121878_());
                        changed = true;
                    }
                } else if (uipos.m_203193_((Position)target.m_20182_()) > 2.78) {
                    Vec3 p = target.m_20182_();
                    nbt.m_128356_("target", new BlockPos((int)p.f_82479_, (int)p.f_82480_, (int)p.f_82481_).m_121878_());
                    changed = true;
                }
            }
            if (changed && target != null && target.m_20193_() != null) {
                String target_dimension = this.dimensionName(target.m_20193_());
                if (!nbt.m_128461_("dimensionid").equals(target_dimension)) {
                    nbt.m_128359_("dimensionid", target_dimension);
                    changed = true;
                }
            }
        }
        if (changed) {
            stack.m_41700_("trackerdata", (Tag)nbt);
        }
    }
}

