/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.items;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.wilescollection.items.ModItem;
import wile.wilescollection.libmc.Auxiliaries;

public class Trinkets {
    public static final long CFG_DEFAULT = 0L;
    private static int max_charges_ = 4096;
    private static int repair_max_tick_damage_ = 100;
    private static Map<Item, Integer> charging_items_ = new HashMap<Item, Integer>();
    private static Set<Enchantment> allowed_enchantments_ = new HashSet<Enchantment>();

    public static void on_config() {
        charging_items_.clear();
        charging_items_.put(Items.f_42534_, 25);
        charging_items_.put(Items.f_41854_, 225);
        charging_items_.put(Items.f_151049_, 20);
        charging_items_.put(Items.f_150998_, 50);
    }

    public static class TrinketItem
    extends ModItem {
        protected final long trinket_config;

        public TrinketItem(long config, Item.Properties properties) {
            super(properties);
            this.trinket_config = config;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
            int charges;
            if (!Auxiliaries.Tooltip.extendedTipCondition() && !Auxiliaries.Tooltip.helpCondition() && (charges = this.getCharge(stack)) > 0) {
                tooltip.add((Component)Component.m_237115_((String)Auxiliaries.localize(this.m_5524_() + ".tip.charge", charges)));
            }
            super.m_7373_(stack, world, tooltip, flag);
        }

        public boolean m_142522_(ItemStack stack) {
            return this.getDurability(stack) > 0.0f;
        }

        public int m_142158_(ItemStack stack) {
            return Math.round(13.0f * this.getDurability(stack));
        }

        public int m_142159_(ItemStack stack) {
            return 2990071;
        }

        public boolean m_5812_(ItemStack stack) {
            return false;
        }

        public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
            return true;
        }

        public boolean m_8120_(ItemStack stack) {
            return true;
        }

        public int m_6473_() {
            return 35;
        }

        public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
            return EnchantmentHelper.m_44831_((ItemStack)book).keySet().stream().anyMatch(ench -> allowed_enchantments_.contains(ench));
        }

        public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
            return allowed_enchantments_.contains(enchantment);
        }

        public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
            if (!stack.m_41782_() || (world.m_46467_() & 3L) != 0L || !(entity instanceof ServerPlayer)) {
                return;
            }
            CompoundTag tag = this.getNbt(stack);
            boolean changed = false;
            if (changed |= this.repairTick(stack, world, (ServerPlayer)entity, itemSlot, isSelected)) {
                this.updateDurabilityBarValue(stack);
            }
        }

        public boolean hasCustomEntity(ItemStack stack) {
            return true;
        }

        @Nullable
        public Entity createEntity(Level world, Entity entity, ItemStack stack) {
            if (entity instanceof ItemEntity) {
                ((ItemEntity)entity).m_32064_();
                ((ItemEntity)entity).m_20331_(true);
            }
            return null;
        }

        private CompoundTag getNbt(ItemStack trinket) {
            return trinket.m_41698_("trinket");
        }

        private TrinketItem setNbt(ItemStack trinket, CompoundTag nbt) {
            trinket.m_41784_().m_128365_("trinket", (Tag)nbt);
            return this;
        }

        private float getDurability(ItemStack trinket) {
            return this.getNbt(trinket).m_128457_("durability");
        }

        private TrinketItem setDurability(ItemStack trinket, float value) {
            this.getNbt(trinket).m_128350_("durability", Mth.m_14036_((float)value, (float)0.0f, (float)1.0f));
            return this;
        }

        private void updateDurabilityBarValue(ItemStack trinket) {
            float charges = (float)this.getCharge(trinket) / (float)Math.max(this.getMaxCharge(trinket), 1);
            this.setDurability(trinket, charges);
        }

        private void setCharge(ItemStack trinket, int charges) {
            if (charges <= 0) {
                this.getNbt(trinket).m_128473_("charge");
            } else {
                this.getNbt(trinket).m_128405_("charge", charges);
            }
        }

        private int getCharge(ItemStack trinket) {
            return this.getNbt(trinket).m_128451_("charge");
        }

        private int getMaxCharge(ItemStack trinket) {
            return max_charges_;
        }

        private void rechargeTick(ItemStack trinket, Level world, ItemEntity entity) {
            AABB bb;
            List near_items;
            Vec3 pos;
            if (!entity.m_20096_()) {
                pos = Vec3.m_82528_((Vec3i)entity.m_20183_()).m_82520_(0.5, 0.0, 0.5);
                if (entity.m_20182_().m_82557_(pos) > 0.01) {
                    entity.m_6034_(pos.f_82479_, entity.m_20186_(), pos.f_82481_);
                    entity.m_20334_(0.0, entity.m_20184_().f_82480_, 0.0);
                }
            }
            if (!(near_items = world.m_6443_(ItemEntity.class, new AABB(entity.m_20183_()).m_82406_(0.5).m_82377_(0.0, 0.5, 0.0), e -> e.m_6084_())).isEmpty()) {
                boolean changed = false;
                for (ItemEntity e2 : near_items) {
                    ItemStack stack = e2.m_32055_();
                    Item item = stack.m_41720_();
                    if (!charging_items_.containsKey(item)) continue;
                    int max_charge = this.getMaxCharge(trinket);
                    int charge = this.getCharge(trinket);
                    if (charge >= max_charge) continue;
                    int item_charges = charging_items_.getOrDefault(item, 1);
                    int n = Mth.m_14045_((int)((int)Math.ceil(((float)max_charge - (float)charge) / (float)item_charges)), (int)1, (int)stack.m_41613_());
                    this.setCharge(trinket, charge + n * item_charges);
                    changed = true;
                    if (n >= stack.m_41613_()) {
                        e2.m_32055_().m_41764_(0);
                        e2.m_142687_(Entity.RemovalReason.DISCARDED);
                        continue;
                    }
                    e2.m_32055_().m_41774_(n);
                }
                if (changed) {
                    this.updateDurabilityBarValue(trinket);
                    world.m_5594_(null, entity.m_20183_(), SoundEvents.f_11752_, SoundSource.BLOCKS, 0.7f, 1.8f);
                }
            }
            if (world.m_6443_(Player.class, bb = new AABB((pos = entity.m_20182_()).m_82520_(0.5, 2.0, 0.5), pos.m_82492_(0.5, 1.0, 0.5)), e -> e.m_6084_()).isEmpty()) {
                entity.m_32010_(10);
            }
        }

        public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
            Block block_below;
            if (entity.m_6084_() && ((block_below = entity.m_9236_().m_8055_(entity.m_20183_().m_7495_()).m_60734_()) == Blocks.f_50322_ || block_below == Blocks.f_50324_ || block_below == Blocks.f_50323_)) {
                this.rechargeTick(stack, entity.m_9236_(), entity);
            }
            return false;
        }

        private boolean repairTick(ItemStack trinket, Level world, ServerPlayer player, int itemSlot, boolean isSelected) {
            if ((world.m_46467_() & 0x7FL) != 0L) {
                return false;
            }
            int initial_repair_left = this.getCharge(trinket);
            if (initial_repair_left == 0) {
                return false;
            }
            int repair_left = initial_repair_left;
            for (ItemStack armor : player.m_6168_()) {
                repair_left = this.repair(trinket, world, player, repair_left, armor);
            }
            if (!player.f_20911_) {
                repair_left = this.repair(trinket, world, player, repair_left, player.m_21205_());
                repair_left = this.repair(trinket, world, player, repair_left, player.m_21206_());
            }
            this.setCharge(trinket, repair_left);
            if (repair_left <= 0) {
                world.m_5594_(null, player.m_20183_(), SoundEvents.f_11794_, SoundSource.PLAYERS, 1.0f, 1.5f);
            }
            return repair_left != initial_repair_left;
        }

        private int repair(ItemStack trinket, Level world, ServerPlayer player, int repair_left, ItemStack item) {
            if (repair_left <= 0 || item.m_41619_() || !item.m_41768_() || !item.m_41763_()) {
                return repair_left;
            }
            if (!(item.m_41720_() instanceof ArmorItem || item.m_41720_() instanceof TieredItem || item.m_41720_() instanceof ProjectileWeaponItem)) {
                return repair_left;
            }
            int max_repair = Mth.m_14045_((int)Math.min(repair_max_tick_damage_, item.m_41776_() / 10), (int)1, (int)repair_left);
            int repair = Math.min(item.m_41773_(), max_repair);
            item.m_41721_(item.m_41773_() - repair);
            return Math.max(repair_left - repair, 0);
        }
    }
}

