/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.libmc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class Inventories {
    public static boolean areItemStacksIdentical(ItemStack a, ItemStack b) {
        return a.m_41720_() == b.m_41720_() && ItemStack.m_150942_((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemStacksDifferent(ItemStack a, ItemStack b) {
        return a.m_41720_() != b.m_41720_() || !ItemStack.m_150942_((ItemStack)a, (ItemStack)b);
    }

    public static boolean isItemStackableOn(ItemStack a, ItemStack b) {
        return !a.m_41619_() && ItemStack.m_41656_((ItemStack)a, (ItemStack)b) && a.m_41782_() == b.m_41782_() && (!a.m_41782_() || a.m_41783_().equals((Object)b.m_41783_())) && a.areCapsCompatible((CapabilityProvider)b);
    }

    public static IItemHandler itemhandler(Level world, BlockPos pos, @Nullable Direction side) {
        BlockEntity te = world.m_7702_(pos);
        if (te == null) {
            return null;
        }
        IItemHandler ih = (IItemHandler)te.getCapability(ForgeCapabilities.ITEM_HANDLER, side).orElse(null);
        if (ih != null) {
            return ih;
        }
        if (side != null && te instanceof WorldlyContainer) {
            return new SidedInvWrapper((WorldlyContainer)te, side);
        }
        if (te instanceof Container) {
            return new InvWrapper((Container)te);
        }
        return null;
    }

    public static IItemHandler itemhandler(Level world, BlockPos pos, @Nullable Direction side, boolean including_entities) {
        IItemHandler ih = Inventories.itemhandler(world, pos, side);
        if (ih != null) {
            return ih;
        }
        if (!including_entities) {
            return null;
        }
        Entity entity = world.m_6443_(Entity.class, new AABB(pos), e -> e instanceof Container).stream().findFirst().orElse(null);
        return entity == null ? null : Inventories.itemhandler(entity, side);
    }

    public static IItemHandler itemhandler(Entity entity) {
        return entity instanceof Container ? new InvWrapper((Container)entity) : null;
    }

    public static IItemHandler itemhandler(Player player) {
        return new PlayerMainInvWrapper(player.m_150109_());
    }

    public static IItemHandler itemhandler(Entity entity, @Nullable Direction side) {
        return entity instanceof Container ? new InvWrapper((Container)entity) : null;
    }

    public static boolean insertionPossible(Level world, BlockPos pos, @Nullable Direction side, boolean including_entities) {
        return Inventories.itemhandler(world, pos, side, including_entities) != null;
    }

    public static ItemStack insert(IItemHandler handler, ItemStack stack, boolean simulate) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
    }

    public static ItemStack insert(BlockEntity te, @Nullable Direction side, ItemStack stack, boolean simulate) {
        if (te == null) {
            return stack;
        }
        IItemHandler hnd = (IItemHandler)te.getCapability(ForgeCapabilities.ITEM_HANDLER, side).orElse(null);
        if (hnd == null) {
            if (side != null && te instanceof WorldlyContainer) {
                hnd = new SidedInvWrapper((WorldlyContainer)te, side);
            } else if (te instanceof Container) {
                hnd = new InvWrapper((Container)te);
            }
        }
        return hnd == null ? stack : Inventories.insert(hnd, stack, simulate);
    }

    public static ItemStack insert(Level world, BlockPos pos, @Nullable Direction side, ItemStack stack, boolean simulate, boolean including_entities) {
        return Inventories.insert(Inventories.itemhandler(world, pos, side, including_entities), stack, simulate);
    }

    public static ItemStack insert(Level world, BlockPos pos, @Nullable Direction side, ItemStack stack, boolean simulate) {
        return Inventories.insert(world, pos, side, stack, simulate, false);
    }

    public static ItemStack extract(IItemHandler inventory, @Nullable ItemStack match, int amount, boolean simulate) {
        if (inventory == null || amount <= 0 || match != null && match.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int max = inventory.getSlots();
        ItemStack out_stack = ItemStack.f_41583_;
        for (int i = 0; i < max; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            if (out_stack.m_41619_()) {
                if (match != null && Inventories.areItemStacksDifferent(stack, match)) continue;
                out_stack = inventory.extractItem(i, amount, simulate);
            } else if (Inventories.areItemStacksIdentical(stack, out_stack)) {
                ItemStack es = inventory.extractItem(i, amount - out_stack.m_41613_(), simulate);
                out_stack.m_41769_(es.m_41613_());
            }
            if (out_stack.m_41613_() >= amount) break;
        }
        return out_stack;
    }

    private static ItemStack checked(ItemStack stack) {
        return stack.m_41619_() ? ItemStack.f_41583_ : stack;
    }

    public static Container copyOf(Container src) {
        int size = src.m_6643_();
        SimpleContainer dst = new SimpleContainer(size);
        for (int i = 0; i < size; ++i) {
            dst.m_6836_(i, src.m_8020_(i).m_41777_());
        }
        return dst;
    }

    public static ItemStack insert(InventoryRange[] to_ranges, ItemStack stack) {
        ItemStack remaining = stack.m_41777_();
        for (InventoryRange range : to_ranges) {
            if (!(remaining = range.insert(remaining, false, 0, false, true)).m_41619_()) continue;
            return remaining;
        }
        return remaining;
    }

    public static void give(Player entity, ItemStack stack) {
        ItemHandlerHelper.giveItemToPlayer((Player)entity, (ItemStack)stack);
    }

    public static void setItemInPlayerHand(Player player, InteractionHand hand, ItemStack stack) {
        if (stack.m_41619_()) {
            stack = ItemStack.f_41583_;
        }
        if (hand == InteractionHand.MAIN_HAND) {
            player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)stack);
        } else {
            player.m_150109_().f_35976_.set(0, (Object)stack);
        }
    }

    public static Container readNbtStacks(CompoundTag nbt, String key, Container target) {
        NonNullList<ItemStack> stacks = Inventories.readNbtStacks(nbt, key, target.m_6643_());
        for (int i = 0; i < stacks.size(); ++i) {
            target.m_6836_(i, (ItemStack)stacks.get(i));
        }
        return target;
    }

    public static NonNullList<ItemStack> readNbtStacks(CompoundTag nbt, String key, int size) {
        NonNullList stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        if (nbt == null || !nbt.m_128425_(key, 10)) {
            return stacks;
        }
        CompoundTag stacknbt = nbt.m_128469_(key);
        ContainerHelper.m_18980_((CompoundTag)stacknbt, (NonNullList)stacks);
        return stacks;
    }

    public static NonNullList<ItemStack> readNbtStacks(CompoundTag nbt, int size) {
        NonNullList stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        if (nbt == null || !nbt.m_128425_("Items", 9)) {
            return stacks;
        }
        ContainerHelper.m_18980_((CompoundTag)nbt, (NonNullList)stacks);
        return stacks;
    }

    public static CompoundTag writeNbtStacks(CompoundTag nbt, String key, NonNullList<ItemStack> stacks, boolean omit_trailing_empty) {
        CompoundTag stacknbt = new CompoundTag();
        if (omit_trailing_empty) {
            for (int i = stacks.size() - 1; i >= 0 && ((ItemStack)stacks.get(i)).m_41619_(); --i) {
                stacks.remove(i);
            }
        }
        ContainerHelper.m_18973_((CompoundTag)stacknbt, stacks);
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128365_(key, (Tag)stacknbt);
        return nbt;
    }

    public static CompoundTag writeNbtStacks(CompoundTag nbt, String key, NonNullList<ItemStack> stacks) {
        return Inventories.writeNbtStacks(nbt, key, stacks, false);
    }

    public static void dropStack(Level world, Vec3 pos, ItemStack stack, Vec3 velocity, double position_noise, double velocity_noise) {
        if (stack.m_41619_()) {
            return;
        }
        if (position_noise > 0.0) {
            position_noise = Math.min(position_noise, 0.8);
            pos = pos.m_82520_(position_noise * (world.m_213780_().m_188500_() - 0.5), position_noise * (world.m_213780_().m_188500_() - 0.5), position_noise * (world.m_213780_().m_188500_() - 0.5));
        }
        if (velocity_noise > 0.0) {
            velocity_noise = Math.min(velocity_noise, 1.0);
            velocity = velocity.m_82520_(velocity_noise * (world.m_213780_().m_188500_() - 0.5), velocity_noise * (world.m_213780_().m_188500_() - 0.5), velocity_noise * (world.m_213780_().m_188500_() - 0.5));
        }
        ItemEntity e = new ItemEntity(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, stack);
        e.m_20334_((double)((float)velocity.f_82479_), (double)((float)velocity.f_82480_), (double)((float)velocity.f_82481_));
        e.m_32060_();
        world.m_7967_((Entity)e);
    }

    public static void dropStack(Level world, Vec3 pos, ItemStack stack, Vec3 velocity) {
        Inventories.dropStack(world, pos, stack, velocity, 0.3, 0.2);
    }

    public static void dropStack(Level world, Vec3 pos, ItemStack stack) {
        Inventories.dropStack(world, pos, stack, Vec3.f_82478_, 0.3, 0.2);
    }

    public static class InventoryRange
    implements Container,
    Iterable<ItemStack> {
        protected final Container inventory_;
        protected final int offset_;
        protected final int size_;
        protected final int num_rows;
        protected int max_stack_size_ = 64;
        protected BiPredicate<Integer, ItemStack> validator_ = (index, stack) -> true;

        public static InventoryRange fromPlayerHotbar(Player player) {
            return new InventoryRange((Container)player.m_150109_(), 0, 9, 1);
        }

        public static InventoryRange fromPlayerStorage(Player player) {
            return new InventoryRange((Container)player.m_150109_(), 9, 27, 3);
        }

        public static InventoryRange fromPlayerInventory(Player player) {
            return new InventoryRange((Container)player.m_150109_(), 0, 36, 4);
        }

        public InventoryRange(Container inventory, int offset, int size, int num_rows) {
            this.inventory_ = inventory;
            this.offset_ = Mth.m_14045_((int)offset, (int)0, (int)(inventory.m_6643_() - 1));
            this.size_ = Mth.m_14045_((int)size, (int)0, (int)(inventory.m_6643_() - this.offset_));
            this.num_rows = num_rows;
        }

        public InventoryRange(Container inventory, int offset, int size) {
            this(inventory, offset, size, 1);
        }

        public InventoryRange(Container inventory) {
            this(inventory, 0, inventory.m_6643_(), 1);
        }

        public final Container inventory() {
            return this.inventory_;
        }

        public final int size() {
            return this.size_;
        }

        public final int offset() {
            return this.offset_;
        }

        public final ItemStack get(int index) {
            return this.inventory_.m_8020_(this.offset_ + index);
        }

        public final void set(int index, ItemStack stack) {
            this.inventory_.m_6836_(this.offset_ + index, stack);
        }

        public final InventoryRange setValidator(BiPredicate<Integer, ItemStack> validator) {
            this.validator_ = validator;
            return this;
        }

        public final BiPredicate<Integer, ItemStack> getValidator() {
            return this.validator_;
        }

        public final InventoryRange setMaxStackSize(int count) {
            this.max_stack_size_ = Math.max(count, 1);
            return this;
        }

        public void m_6211_() {
            for (int i = 0; i < this.size_; ++i) {
                this.m_6836_(i, ItemStack.f_41583_);
            }
        }

        public int m_6643_() {
            return this.size_;
        }

        public boolean m_7983_() {
            for (int i = 0; i < this.size_; ++i) {
                if (this.inventory_.m_8020_(this.offset_ + i).m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int index) {
            return this.inventory_.m_8020_(this.offset_ + index);
        }

        public ItemStack m_7407_(int index, int count) {
            return this.inventory_.m_7407_(this.offset_ + index, count);
        }

        public ItemStack m_8016_(int index) {
            return this.inventory_.m_8016_(this.offset_ + index);
        }

        public void m_6836_(int index, ItemStack stack) {
            this.inventory_.m_6836_(this.offset_ + index, stack);
        }

        public int m_6893_() {
            return Math.min(this.max_stack_size_, this.inventory_.m_6893_());
        }

        public void m_6596_() {
            this.inventory_.m_6596_();
        }

        public boolean m_6542_(Player player) {
            return this.inventory_.m_6542_(player);
        }

        public void m_5856_(Player player) {
            this.inventory_.m_5856_(player);
        }

        public void m_5785_(Player player) {
            this.inventory_.m_5785_(player);
        }

        public boolean m_7013_(int index, ItemStack stack) {
            return this.validator_.test(this.offset_ + index, stack) && this.inventory_.m_7013_(this.offset_ + index, stack);
        }

        public boolean iterate(BiPredicate<Integer, ItemStack> fn) {
            for (int i = 0; i < this.size_; ++i) {
                if (!fn.test(i, this.m_8020_(i))) continue;
                return true;
            }
            return false;
        }

        public boolean contains(ItemStack stack) {
            for (int i = 0; i < this.size_; ++i) {
                if (!Inventories.areItemStacksIdentical(stack, this.m_8020_(i))) continue;
                return true;
            }
            return false;
        }

        public int indexOf(ItemStack stack) {
            for (int i = 0; i < this.size_; ++i) {
                if (!Inventories.areItemStacksIdentical(stack, this.m_8020_(i))) continue;
                return i;
            }
            return -1;
        }

        public <T> Optional<T> find(BiFunction<Integer, ItemStack, Optional<T>> fn) {
            for (int i = 0; i < this.size_; ++i) {
                Optional<T> r = fn.apply(i, this.m_8020_(i));
                if (!r.isPresent()) continue;
                return r;
            }
            return Optional.empty();
        }

        public <T> List<T> collect(BiFunction<Integer, ItemStack, Optional<T>> fn) {
            ArrayList data = new ArrayList();
            for (int i = 0; i < this.size_; ++i) {
                fn.apply(i, this.m_8020_(i)).ifPresent(data::add);
            }
            return data;
        }

        public Stream<ItemStack> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return new InventoryRangeIterator(this);
        }

        public int stackMatchCount(ItemStack ref_stack) {
            int n = 0;
            for (int i = 0; i < this.size_; ++i) {
                if (!Inventories.areItemStacksIdentical(ref_stack, this.m_8020_(i))) continue;
                ++n;
            }
            return n;
        }

        public int totalMatchingItemCount(ItemStack ref_stack) {
            int n = 0;
            for (int i = 0; i < this.size_; ++i) {
                ItemStack stack = this.m_8020_(i);
                if (!Inventories.areItemStacksIdentical(ref_stack, stack)) continue;
                n += stack.m_41613_();
            }
            return n;
        }

        public ItemStack insert(ItemStack input_stack, boolean only_fillup, int limit, boolean reverse, boolean force_group_stacks) {
            int nmax;
            ItemStack stack;
            int sno;
            int i;
            ItemStack mvstack = input_stack.m_41777_();
            if (mvstack.m_41619_()) {
                return Inventories.checked(mvstack);
            }
            int limit_left = limit > 0 ? Math.min(limit, mvstack.m_41741_()) : mvstack.m_41741_();
            boolean[] matches = new boolean[this.size_];
            boolean[] empties = new boolean[this.size_];
            int num_matches = 0;
            for (i = 0; i < this.size_; ++i) {
                sno = reverse ? this.size_ - 1 - i : i;
                stack = this.m_8020_(sno);
                if (stack.m_41619_()) {
                    empties[sno] = true;
                    continue;
                }
                if (!Inventories.areItemStacksIdentical(stack, mvstack)) continue;
                matches[sno] = true;
                ++num_matches;
            }
            for (i = 0; i < this.size_; ++i) {
                int n = sno = reverse ? this.size_ - 1 - i : i;
                if (empties[sno] || !matches[sno]) continue;
                stack = this.m_8020_(sno);
                nmax = Math.min(limit_left, stack.m_41741_() - stack.m_41613_());
                if (mvstack.m_41613_() <= nmax) {
                    stack.m_41764_(stack.m_41613_() + mvstack.m_41613_());
                    this.m_6836_(sno, stack);
                    return ItemStack.f_41583_;
                }
                stack.m_41769_(nmax);
                mvstack.m_41774_(nmax);
                this.m_6836_(sno, stack);
                limit_left -= nmax;
            }
            if (only_fillup) {
                return Inventories.checked(mvstack);
            }
            if (num_matches > 0 && (force_group_stacks || this.inventory_ instanceof Inventory)) {
                int sno2;
                int i2;
                int insert_start = -1;
                int insert_end = -1;
                for (i2 = 1; i2 < this.size_ - 1; ++i2) {
                    int n = sno2 = reverse ? this.size_ - 1 - i2 : i2;
                    if (insert_start < 0) {
                        if (!matches[sno2]) continue;
                        insert_start = sno2;
                        continue;
                    }
                    if (!matches[sno2]) continue;
                    insert_end = sno2;
                }
                for (i2 = insert_start; i2 < insert_end; ++i2) {
                    int n = sno2 = reverse ? this.size_ - 1 - i2 : i2;
                    if (!empties[sno2] || !this.m_7013_(sno2, mvstack)) continue;
                    int nmax2 = Math.min(limit_left, mvstack.m_41613_());
                    ItemStack moved = mvstack.m_41777_();
                    moved.m_41764_(nmax2);
                    mvstack.m_41774_(nmax2);
                    this.m_6836_(sno2, moved);
                    return Inventories.checked(mvstack);
                }
                for (i = 1; i < this.size_ - 1; ++i) {
                    int ii;
                    int n = sno = reverse ? this.size_ - 1 - i : i;
                    if (!matches[sno]) continue;
                    int n2 = empties[sno - 1] ? sno - 1 : (ii = empties[sno + 1] ? sno + 1 : -1);
                    if (ii < 0 || !this.m_7013_(ii, mvstack)) continue;
                    nmax = Math.min(limit_left, mvstack.m_41613_());
                    ItemStack moved = mvstack.m_41777_();
                    moved.m_41764_(nmax);
                    mvstack.m_41774_(nmax);
                    this.m_6836_(ii, moved);
                    return Inventories.checked(mvstack);
                }
            }
            for (i = 0; i < this.size_; ++i) {
                int n = sno = reverse ? this.size_ - 1 - i : i;
                if (!empties[sno] || !this.m_7013_(sno, mvstack)) continue;
                int nmax3 = Math.min(limit_left, mvstack.m_41613_());
                ItemStack placed = mvstack.m_41777_();
                placed.m_41764_(nmax3);
                mvstack.m_41774_(nmax3);
                this.m_6836_(sno, placed);
                return Inventories.checked(mvstack);
            }
            return Inventories.checked(mvstack);
        }

        public ItemStack insert(ItemStack stack_to_move) {
            return this.insert(stack_to_move, false, 0, false, true);
        }

        public ItemStack insert(int index, ItemStack stack_to_move) {
            if (stack_to_move.m_41619_()) {
                return stack_to_move;
            }
            ItemStack stack = this.m_8020_(index);
            int limit = Math.min(this.m_6893_(), stack.m_41741_());
            if (stack.m_41619_()) {
                this.m_6836_(index, stack_to_move.m_41777_());
                return ItemStack.f_41583_;
            }
            if (stack.m_41613_() >= limit || !Inventories.areItemStacksIdentical(stack, stack_to_move)) {
                return stack_to_move;
            }
            int amount = Math.min(limit - stack.m_41613_(), stack_to_move.m_41613_());
            ItemStack remaining = stack_to_move.m_41777_();
            remaining.m_41774_(amount);
            stack.m_41769_(amount);
            return remaining.m_41619_() ? ItemStack.f_41583_ : remaining;
        }

        public ItemStack extract(int amount) {
            return this.extract(amount, false);
        }

        public ItemStack extract(int amount, boolean random) {
            ItemStack out_stack = ItemStack.f_41583_;
            int offset = random ? (int)(Math.random() * (double)this.size_) : 0;
            for (int k = 0; k < this.size_; ++k) {
                int i = (offset + k) % this.size_;
                ItemStack stack = this.m_8020_(i);
                if (stack.m_41619_()) continue;
                if (out_stack.m_41619_()) {
                    if (stack.m_41613_() < amount) {
                        out_stack = stack;
                        this.m_6836_(i, ItemStack.f_41583_);
                        if (!out_stack.m_41753_()) break;
                        amount -= out_stack.m_41613_();
                        continue;
                    }
                    out_stack = stack.m_41620_(amount);
                    break;
                }
                if (!Inventories.areItemStacksIdentical(stack, out_stack)) continue;
                if (stack.m_41613_() <= amount) {
                    out_stack.m_41769_(stack.m_41613_());
                    amount -= stack.m_41613_();
                    this.m_6836_(i, ItemStack.f_41583_);
                    continue;
                }
                out_stack.m_41769_(amount);
                stack.m_41774_(amount);
                if (!stack.m_41619_()) break;
                this.m_6836_(i, ItemStack.f_41583_);
                break;
            }
            if (!out_stack.m_41619_()) {
                this.m_6596_();
            }
            return out_stack;
        }

        public ItemStack extract(ItemStack request_stack) {
            ItemStack stack;
            if (request_stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ArrayList<ItemStack> matches = new ArrayList<ItemStack>();
            for (int i = 0; i < this.size_; ++i) {
                ItemStack stack2 = this.m_8020_(i);
                if (stack2.m_41619_() || !Inventories.areItemStacksIdentical(stack2, request_stack)) continue;
                if (stack2.m_41782_()) {
                    CompoundTag nbt = stack2.m_41784_();
                    int n = nbt.m_128440_();
                    if (n > 0 && nbt.m_128441_("Damage")) {
                        --n;
                    }
                    if (n > 0) continue;
                }
                matches.add(stack2);
            }
            matches.sort(Comparator.comparingInt(ItemStack::m_41613_));
            if (matches.isEmpty()) {
                return ItemStack.f_41583_;
            }
            int n_left = request_stack.m_41613_();
            ItemStack fetched_stack = ((ItemStack)matches.get(0)).m_41620_(n_left);
            n_left -= fetched_stack.m_41613_();
            for (int i = 1; i < matches.size() && n_left > 0; n_left -= stack.m_41613_(), ++i) {
                stack = ((ItemStack)matches.get(i)).m_41620_(n_left);
                fetched_stack.m_41769_(stack.m_41613_());
            }
            return Inventories.checked(fetched_stack);
        }

        public boolean move(int index, InventoryRange target_range, boolean all_identical_stacks, boolean only_fillup, boolean reverse, boolean force_group_stacks) {
            ItemStack source_stack = this.m_8020_(index);
            if (source_stack.m_41619_()) {
                return false;
            }
            if (!all_identical_stacks) {
                ItemStack remaining = target_range.insert(source_stack, only_fillup, 0, reverse, force_group_stacks);
                this.m_6836_(index, remaining);
                return remaining.m_41613_() != source_stack.m_41613_();
            }
            ItemStack remaining = source_stack.m_41777_();
            this.m_6836_(index, ItemStack.f_41583_);
            ItemStack ref_stack = remaining.m_41777_();
            ref_stack.m_41764_(ref_stack.m_41741_());
            for (int i = this.size_; i > 0 && !remaining.m_41619_() && (remaining = target_range.insert(remaining, only_fillup, 0, reverse, force_group_stacks)).m_41619_(); --i) {
                remaining = this.extract(ref_stack);
            }
            if (!remaining.m_41619_()) {
                this.m_6836_(index, remaining);
            }
            return remaining.m_41613_() != source_stack.m_41613_();
        }

        public boolean move(int index, InventoryRange target_range) {
            return this.move(index, target_range, false, false, false, true);
        }

        public boolean move(InventoryRange target_range, boolean only_fillup, boolean reverse, boolean force_group_stacks) {
            boolean changed = false;
            for (int i = 0; i < this.size_; ++i) {
                changed |= this.move(i, target_range, false, only_fillup, reverse, force_group_stacks);
            }
            return changed;
        }

        public boolean move(InventoryRange target_range, boolean only_fillup) {
            return this.move(target_range, only_fillup, false, true);
        }

        public boolean move(InventoryRange target_range) {
            return this.move(target_range, false, false, true);
        }

        public static class InventoryRangeIterator
        implements Iterator<ItemStack> {
            private final InventoryRange parent_;
            private int index = 0;

            public InventoryRangeIterator(InventoryRange range) {
                this.parent_ = range;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.parent_.size_;
            }

            @Override
            public ItemStack next() {
                if (this.index >= this.parent_.size_) {
                    throw new NoSuchElementException();
                }
                return this.parent_.m_8020_(this.index++);
            }
        }
    }

    public static class StorageInventory
    implements Container,
    Iterable<ItemStack> {
        protected final NonNullList<ItemStack> stacks_;
        protected final BlockEntity te_;
        protected final int size_;
        protected final int num_rows_;
        protected int stack_limit_ = 64;
        protected BiPredicate<Integer, ItemStack> validator_ = (index, stack) -> true;
        protected Consumer<Player> open_action_ = player -> {};
        protected Consumer<Player> close_action_ = player -> {};
        protected BiConsumer<Integer, ItemStack> slot_set_action_ = (index, stack) -> {};

        public StorageInventory(BlockEntity te, int size) {
            this(te, size, 1);
        }

        public StorageInventory(BlockEntity te, int size, int num_rows) {
            this.te_ = te;
            this.size_ = Math.max(size, 1);
            this.stacks_ = NonNullList.m_122780_((int)this.size_, (Object)ItemStack.f_41583_);
            this.num_rows_ = Mth.m_14045_((int)num_rows, (int)1, (int)this.size_);
        }

        public CompoundTag save(CompoundTag nbt, String key) {
            nbt.m_128365_(key, (Tag)this.save(new CompoundTag(), false));
            return nbt;
        }

        public CompoundTag save(CompoundTag nbt) {
            return ContainerHelper.m_18973_((CompoundTag)nbt, this.stacks_);
        }

        public CompoundTag save(CompoundTag nbt, boolean save_empty) {
            return ContainerHelper.m_18976_((CompoundTag)nbt, this.stacks_, (boolean)save_empty);
        }

        public CompoundTag save(boolean save_empty) {
            return this.save(new CompoundTag(), save_empty);
        }

        public StorageInventory load(CompoundTag nbt, String key) {
            if (!nbt.m_128425_("key", 10)) {
                this.stacks_.clear();
                return this;
            }
            return this.load(nbt.m_128469_(key));
        }

        public StorageInventory load(CompoundTag nbt) {
            this.stacks_.clear();
            ContainerHelper.m_18980_((CompoundTag)nbt, this.stacks_);
            return this;
        }

        public List<ItemStack> stacks() {
            return this.stacks_;
        }

        public BlockEntity getBlockEntity() {
            return this.te_;
        }

        public StorageInventory setOpenAction(Consumer<Player> fn) {
            this.open_action_ = fn;
            return this;
        }

        public StorageInventory setCloseAction(Consumer<Player> fn) {
            this.close_action_ = fn;
            return this;
        }

        public StorageInventory setSlotChangeAction(BiConsumer<Integer, ItemStack> fn) {
            this.slot_set_action_ = fn;
            return this;
        }

        public StorageInventory setStackLimit(int max_slot_stack_size) {
            this.stack_limit_ = Math.max(max_slot_stack_size, 1);
            return this;
        }

        public StorageInventory setValidator(BiPredicate<Integer, ItemStack> validator) {
            this.validator_ = validator;
            return this;
        }

        public BiPredicate<Integer, ItemStack> getValidator() {
            return this.validator_;
        }

        @Override
        public Iterator<ItemStack> iterator() {
            return this.stacks_.iterator();
        }

        public Stream<ItemStack> stream() {
            return this.stacks_.stream();
        }

        public int m_6643_() {
            return this.size_;
        }

        public boolean m_7983_() {
            for (ItemStack stack : this.stacks_) {
                if (stack.m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int index) {
            return index < this.size_ ? (ItemStack)this.stacks_.get(index) : ItemStack.f_41583_;
        }

        public ItemStack m_7407_(int index, int count) {
            return ContainerHelper.m_18969_(this.stacks_, (int)index, (int)count);
        }

        public ItemStack m_8016_(int index) {
            return ContainerHelper.m_18966_(this.stacks_, (int)index);
        }

        public void m_6836_(int index, ItemStack stack) {
            this.stacks_.set(index, (Object)stack);
            if (stack.m_41613_() != ((ItemStack)this.stacks_.get(index)).m_41613_() || !Inventories.areItemStacksDifferent((ItemStack)this.stacks_.get(index), stack)) {
                this.slot_set_action_.accept(index, stack);
            }
        }

        public int m_6893_() {
            return this.stack_limit_;
        }

        public void m_6596_() {
            this.te_.m_6596_();
        }

        public boolean m_6542_(Player player) {
            return this.te_.m_58904_().m_7702_(this.te_.m_58899_()) == this.te_ && this.te_.m_58899_().m_123331_((Vec3i)player.m_20183_()) < 64.0;
        }

        public void m_5856_(Player player) {
            this.open_action_.accept(player);
        }

        public void m_5785_(Player player) {
            this.m_6596_();
            this.close_action_.accept(player);
        }

        public boolean m_7013_(int index, ItemStack stack) {
            return this.validator_.test(index, stack);
        }

        public void m_6211_() {
            this.stacks_.clear();
            this.m_6596_();
        }
    }

    public static class MappedItemHandler
    implements IItemHandler {
        private final BiPredicate<Integer, ItemStack> extraction_predicate_;
        private final BiPredicate<Integer, ItemStack> insertion_predicate_;
        private final BiConsumer<Integer, ItemStack> insertion_notifier_;
        private final BiConsumer<Integer, ItemStack> extraction_notifier_;
        private final List<Integer> slot_map_;
        private final Container inv_;

        public MappedItemHandler(Container inv, BiPredicate<Integer, ItemStack> extraction_predicate, BiPredicate<Integer, ItemStack> insertion_predicate, BiConsumer<Integer, ItemStack> insertion_notifier, BiConsumer<Integer, ItemStack> extraction_notifier) {
            this.inv_ = inv;
            this.extraction_predicate_ = extraction_predicate;
            this.insertion_predicate_ = insertion_predicate;
            this.insertion_notifier_ = insertion_notifier;
            this.extraction_notifier_ = extraction_notifier;
            this.slot_map_ = IntStream.range(0, inv.m_6643_()).boxed().collect(Collectors.toList());
        }

        public MappedItemHandler(Container inv, List<Integer> slot_map, BiPredicate<Integer, ItemStack> extraction_predicate, BiPredicate<Integer, ItemStack> insertion_predicate, BiConsumer<Integer, ItemStack> insertion_notifier, BiConsumer<Integer, ItemStack> extraction_notifier) {
            this.inv_ = inv;
            this.extraction_predicate_ = extraction_predicate;
            this.insertion_predicate_ = insertion_predicate;
            this.insertion_notifier_ = insertion_notifier;
            this.extraction_notifier_ = extraction_notifier;
            this.slot_map_ = slot_map;
        }

        public MappedItemHandler(Container inv, List<Integer> slot_map, BiPredicate<Integer, ItemStack> extraction_predicate, BiPredicate<Integer, ItemStack> insertion_predicate) {
            this(inv, slot_map, extraction_predicate, insertion_predicate, (i, s) -> {}, (i, s) -> {});
        }

        public MappedItemHandler(Container inv, BiPredicate<Integer, ItemStack> extraction_predicate, BiPredicate<Integer, ItemStack> insertion_predicate) {
            this(inv, IntStream.range(0, inv.m_6643_()).boxed().collect(Collectors.toList()), extraction_predicate, insertion_predicate);
        }

        public MappedItemHandler(Container inv) {
            this(inv, (i, s) -> true, (i, s) -> true);
        }

        public int hashCode() {
            return this.inv_.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o != null && this.getClass() == o.getClass() && this.inv_.equals(((MappedItemHandler)o).inv_);
        }

        public int getSlots() {
            return this.slot_map_.size();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot >= this.slot_map_.size() ? ItemStack.f_41583_ : this.inv_.m_8020_(this.slot_map_.get(slot).intValue());
        }

        public int getSlotLimit(int slot) {
            return this.inv_.m_6893_();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (slot >= this.slot_map_.size()) {
                return false;
            }
            return this.insertion_predicate_.test(slot = this.slot_map_.get(slot).intValue(), stack) && this.inv_.m_7013_(slot, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (slot >= this.slot_map_.size()) {
                return stack;
            }
            if (!this.insertion_predicate_.test(slot = this.slot_map_.get(slot).intValue(), stack)) {
                return stack;
            }
            if (!this.inv_.m_7013_(slot, stack)) {
                return stack;
            }
            ItemStack sst = this.inv_.m_8020_(slot);
            int slot_limit = this.inv_.m_6893_();
            if (!sst.m_41619_()) {
                if (sst.m_41613_() >= Math.min(sst.m_41741_(), slot_limit)) {
                    return stack;
                }
                if (!Inventories.isItemStackableOn(stack, sst)) {
                    return stack;
                }
                int limit = Math.min(stack.m_41741_(), slot_limit) - sst.m_41613_();
                if (stack.m_41613_() <= limit) {
                    if (!simulate) {
                        stack = stack.m_41777_();
                        stack.m_41769_(sst.m_41613_());
                        this.inv_.m_6836_(slot, stack);
                        this.inv_.m_6596_();
                        this.insertion_notifier_.accept(slot, sst);
                    }
                    return ItemStack.f_41583_;
                }
                stack = stack.m_41777_();
                if (simulate) {
                    stack.m_41774_(limit);
                } else {
                    ItemStack diff = stack.m_41620_(limit);
                    sst.m_41769_(diff.m_41613_());
                    this.inv_.m_6836_(slot, sst);
                    this.inv_.m_6596_();
                    this.insertion_notifier_.accept(slot, diff);
                }
                return stack;
            }
            int limit = Math.min(slot_limit, stack.m_41741_());
            if (stack.m_41613_() >= limit) {
                stack = stack.m_41777_();
                ItemStack ins = stack.m_41620_(limit);
                if (!simulate) {
                    this.inv_.m_6836_(slot, ins);
                    this.inv_.m_6596_();
                    this.insertion_notifier_.accept(slot, ins.m_41777_());
                }
                if (stack.m_41619_()) {
                    stack = ItemStack.f_41583_;
                }
                return stack;
            }
            if (!simulate) {
                this.inv_.m_6836_(slot, stack.m_41777_());
                this.inv_.m_6596_();
                this.insertion_notifier_.accept(slot, stack.m_41777_());
            }
            return ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0) {
                return ItemStack.f_41583_;
            }
            if (slot >= this.slot_map_.size()) {
                return ItemStack.f_41583_;
            }
            slot = this.slot_map_.get(slot);
            ItemStack stack = this.inv_.m_8020_(slot);
            if (!this.extraction_predicate_.test(slot, stack)) {
                return ItemStack.f_41583_;
            }
            if (simulate) {
                if (amount < (stack = stack.m_41777_()).m_41613_()) {
                    stack.m_41764_(amount);
                }
            } else {
                stack = this.inv_.m_7407_(slot, Math.min(stack.m_41613_(), amount));
                this.inv_.m_6596_();
                this.extraction_notifier_.accept(slot, stack.m_41777_());
            }
            return stack;
        }

        public static LazyOptional<IItemHandler> createGenericHandler(Container inv, BiPredicate<Integer, ItemStack> extraction_predicate, BiPredicate<Integer, ItemStack> insertion_predicate, BiConsumer<Integer, ItemStack> insertion_notifier, BiConsumer<Integer, ItemStack> extraction_notifier) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, extraction_predicate, insertion_predicate, insertion_notifier, extraction_notifier));
        }

        public static LazyOptional<IItemHandler> createGenericHandler(Container inv, BiPredicate<Integer, ItemStack> extraction_predicate, BiPredicate<Integer, ItemStack> insertion_predicate, BiConsumer<Integer, ItemStack> insertion_notifier, BiConsumer<Integer, ItemStack> extraction_notifier, List<Integer> slot_map) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, slot_map, extraction_predicate, insertion_predicate, insertion_notifier, extraction_notifier));
        }

        public static LazyOptional<IItemHandler> createGenericHandler(Container inv, BiPredicate<Integer, ItemStack> extraction_predicate, BiPredicate<Integer, ItemStack> insertion_predicate, List<Integer> slot_map) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, slot_map, extraction_predicate, insertion_predicate));
        }

        public static LazyOptional<IItemHandler> createGenericHandler(Container inv, BiPredicate<Integer, ItemStack> extraction_predicate, BiPredicate<Integer, ItemStack> insertion_predicate) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, extraction_predicate, insertion_predicate));
        }

        public static LazyOptional<IItemHandler> createGenericHandler(Container inv) {
            return LazyOptional.of(() -> new MappedItemHandler(inv));
        }

        public static LazyOptional<IItemHandler> createExtractionHandler(Container inv, BiPredicate<Integer, ItemStack> extraction_predicate, List<Integer> slot_map) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, slot_map, extraction_predicate, (i, s) -> false));
        }

        public static LazyOptional<IItemHandler> createExtractionHandler(Container inv, BiPredicate<Integer, ItemStack> extraction_predicate) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, extraction_predicate, (i, s) -> false));
        }

        public static LazyOptional<IItemHandler> createExtractionHandler(Container inv, Integer ... slots) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, Arrays.asList(slots), (i, s) -> true, (i, s) -> false));
        }

        public static LazyOptional<IItemHandler> createExtractionHandler(Container inv) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, (i, s) -> true, (i, s) -> false));
        }

        public static LazyOptional<IItemHandler> createInsertionHandler(Container inv, BiPredicate<Integer, ItemStack> insertion_predicate, List<Integer> slot_map) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, slot_map, (i, s) -> false, insertion_predicate));
        }

        public static LazyOptional<IItemHandler> createInsertionHandler(Container inv, Integer ... slots) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, Arrays.asList(slots), (i, s) -> false, (i, s) -> true));
        }

        public static LazyOptional<IItemHandler> createInsertionHandler(Container inv, BiPredicate<Integer, ItemStack> insertion_predicate) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, (i, s) -> false, insertion_predicate));
        }

        public static LazyOptional<IItemHandler> createInsertionHandler(Container inv) {
            return LazyOptional.of(() -> new MappedItemHandler(inv, (i, s) -> false, (i, s) -> true));
        }
    }
}

