/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.libmc;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import wile.wilescollection.libmc.Auxiliaries;
import wile.wilescollection.libmc.SidedProxy;

public class Networking {
    private static final String PROTOCOL = "1";
    private static SimpleChannel DEFAULT_CHANNEL;

    public static void init(String modid) {
        DEFAULT_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(modid, "default_ch")).clientAcceptedVersions(PROTOCOL::equals).serverAcceptedVersions(PROTOCOL::equals).networkProtocolVersion(() -> PROTOCOL).simpleChannel();
        int discr = -1;
        DEFAULT_CHANNEL.registerMessage(++discr, PacketTileNotifyClientToServer.class, PacketTileNotifyClientToServer::compose, PacketTileNotifyClientToServer::parse, PacketTileNotifyClientToServer.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, PacketTileNotifyServerToClient.class, PacketTileNotifyServerToClient::compose, PacketTileNotifyServerToClient::parse, PacketTileNotifyServerToClient.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, PacketContainerSyncClientToServer.class, PacketContainerSyncClientToServer::compose, PacketContainerSyncClientToServer::parse, PacketContainerSyncClientToServer.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, PacketContainerSyncServerToClient.class, PacketContainerSyncServerToClient::compose, PacketContainerSyncServerToClient::parse, PacketContainerSyncServerToClient.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, PacketNbtNotifyClientToServer.class, PacketNbtNotifyClientToServer::compose, PacketNbtNotifyClientToServer::parse, PacketNbtNotifyClientToServer.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, PacketNbtNotifyServerToClient.class, PacketNbtNotifyServerToClient::compose, PacketNbtNotifyServerToClient::parse, PacketNbtNotifyServerToClient.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, OverlayTextMessage.class, OverlayTextMessage::compose, OverlayTextMessage::parse, OverlayTextMessage.Handler::handle);
    }

    public static class PacketTileNotifyClientToServer {
        CompoundTag nbt = null;
        BlockPos pos = BlockPos.f_121853_;

        public static void sendToServer(BlockPos pos, CompoundTag nbt) {
            if (pos != null && nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketTileNotifyClientToServer(pos, nbt));
            }
        }

        public static void sendToServer(BlockEntity te, CompoundTag nbt) {
            if (te != null && nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketTileNotifyClientToServer(te, nbt));
            }
        }

        public PacketTileNotifyClientToServer() {
        }

        public PacketTileNotifyClientToServer(BlockPos pos, CompoundTag nbt) {
            this.nbt = nbt;
            this.pos = pos;
        }

        public PacketTileNotifyClientToServer(BlockEntity te, CompoundTag nbt) {
            this.nbt = nbt;
            this.pos = te.m_58899_();
        }

        public static PacketTileNotifyClientToServer parse(FriendlyByteBuf buf) {
            return new PacketTileNotifyClientToServer(buf.m_130135_(), buf.m_130260_());
        }

        public static void compose(PacketTileNotifyClientToServer pkt, FriendlyByteBuf buf) {
            buf.m_130064_(pkt.pos);
            buf.m_130079_(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketTileNotifyClientToServer pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (player == null) {
                        return;
                    }
                    Level world = player.m_9236_();
                    BlockEntity te = world.m_7702_(pkt.pos);
                    if (!(te instanceof IPacketTileNotifyReceiver)) {
                        return;
                    }
                    ((IPacketTileNotifyReceiver)te).onClientPacketReceived((Player)((NetworkEvent.Context)ctx.get()).getSender(), pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class PacketTileNotifyServerToClient {
        CompoundTag nbt = null;
        BlockPos pos = BlockPos.f_121853_;

        public static void sendToPlayer(Player player, BlockEntity te, CompoundTag nbt) {
            if (!(player instanceof ServerPlayer) || player instanceof FakePlayer || te == null || nbt == null) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new PacketTileNotifyServerToClient(te, nbt), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }

        public static void sendToPlayers(BlockEntity te, CompoundTag nbt) {
            if (te == null || te.m_58904_() == null) {
                return;
            }
            for (Player player : te.m_58904_().m_6907_()) {
                PacketTileNotifyServerToClient.sendToPlayer(player, te, nbt);
            }
        }

        public PacketTileNotifyServerToClient() {
        }

        public PacketTileNotifyServerToClient(BlockPos pos, CompoundTag nbt) {
            this.nbt = nbt;
            this.pos = pos;
        }

        public PacketTileNotifyServerToClient(BlockEntity te, CompoundTag nbt) {
            this.nbt = nbt;
            this.pos = te.m_58899_();
        }

        public static PacketTileNotifyServerToClient parse(FriendlyByteBuf buf) {
            return new PacketTileNotifyServerToClient(buf.m_130135_(), buf.m_130260_());
        }

        public static void compose(PacketTileNotifyServerToClient pkt, FriendlyByteBuf buf) {
            buf.m_130064_(pkt.pos);
            buf.m_130079_(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketTileNotifyServerToClient pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    Level world = SidedProxy.getWorldClientSide();
                    if (world == null) {
                        return;
                    }
                    BlockEntity te = world.m_7702_(pkt.pos);
                    if (!(te instanceof IPacketTileNotifyReceiver)) {
                        return;
                    }
                    ((IPacketTileNotifyReceiver)te).onServerPacketReceived(pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class PacketContainerSyncClientToServer {
        int id = -1;
        CompoundTag nbt = null;

        public static void sendToServer(int windowId, CompoundTag nbt) {
            if (nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketContainerSyncClientToServer(windowId, nbt));
            }
        }

        public static void sendToServer(AbstractContainerMenu container, CompoundTag nbt) {
            if (nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketContainerSyncClientToServer(container.f_38840_, nbt));
            }
        }

        public PacketContainerSyncClientToServer() {
        }

        public PacketContainerSyncClientToServer(int id, CompoundTag nbt) {
            this.nbt = nbt;
            this.id = id;
        }

        public static PacketContainerSyncClientToServer parse(FriendlyByteBuf buf) {
            return new PacketContainerSyncClientToServer(buf.readInt(), buf.m_130260_());
        }

        public static void compose(PacketContainerSyncClientToServer pkt, FriendlyByteBuf buf) {
            buf.writeInt(pkt.id);
            buf.m_130079_(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketContainerSyncClientToServer pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (player == null || !(player.f_36096_ instanceof INetworkSynchronisableContainer)) {
                        return;
                    }
                    if (player.f_36096_.f_38840_ != pkt.id) {
                        return;
                    }
                    ((INetworkSynchronisableContainer)player.f_36096_).onClientPacketReceived(pkt.id, (Player)player, pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class PacketContainerSyncServerToClient {
        int id = -1;
        CompoundTag nbt = null;

        public static void sendToPlayer(Player player, int windowId, CompoundTag nbt) {
            if (!(player instanceof ServerPlayer) || player instanceof FakePlayer || nbt == null) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new PacketContainerSyncServerToClient(windowId, nbt), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }

        public static void sendToPlayer(Player player, AbstractContainerMenu container, CompoundTag nbt) {
            if (!(player instanceof ServerPlayer) || player instanceof FakePlayer || nbt == null) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new PacketContainerSyncServerToClient(container.f_38840_, nbt), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }

        public static <C extends AbstractContainerMenu> void sendToListeners(Level world, C container, CompoundTag nbt) {
            for (Player player : world.m_6907_()) {
                if (player.f_36096_.f_38840_ != container.f_38840_) continue;
                PacketContainerSyncServerToClient.sendToPlayer(player, container.f_38840_, nbt);
            }
        }

        public PacketContainerSyncServerToClient() {
        }

        public PacketContainerSyncServerToClient(int id, CompoundTag nbt) {
            this.nbt = nbt;
            this.id = id;
        }

        public static PacketContainerSyncServerToClient parse(FriendlyByteBuf buf) {
            return new PacketContainerSyncServerToClient(buf.readInt(), buf.m_130260_());
        }

        public static void compose(PacketContainerSyncServerToClient pkt, FriendlyByteBuf buf) {
            buf.writeInt(pkt.id);
            buf.m_130079_(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketContainerSyncServerToClient pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    Player player = SidedProxy.getPlayerClientSide();
                    if (player == null || !(player.f_36096_ instanceof INetworkSynchronisableContainer)) {
                        return;
                    }
                    if (player.f_36096_.f_38840_ != pkt.id) {
                        return;
                    }
                    ((INetworkSynchronisableContainer)player.f_36096_).onServerPacketReceived(pkt.id, pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class PacketNbtNotifyClientToServer {
        public static final Map<String, BiConsumer<Player, CompoundTag>> handlers = new HashMap<String, BiConsumer<Player, CompoundTag>>();
        final CompoundTag nbt;

        public static void sendToServer(CompoundTag nbt) {
            if (nbt != null) {
                DEFAULT_CHANNEL.sendToServer((Object)new PacketNbtNotifyClientToServer(nbt));
            }
        }

        public PacketNbtNotifyClientToServer(CompoundTag nbt) {
            this.nbt = nbt;
        }

        public static PacketNbtNotifyClientToServer parse(FriendlyByteBuf buf) {
            return new PacketNbtNotifyClientToServer(buf.m_130260_());
        }

        public static void compose(PacketNbtNotifyClientToServer pkt, FriendlyByteBuf buf) {
            buf.m_130079_(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketNbtNotifyClientToServer pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                    if (player == null) {
                        return;
                    }
                    String hnd = pkt.nbt.m_128461_("hnd");
                    if (hnd.isEmpty()) {
                        return;
                    }
                    if (handlers.containsKey(hnd)) {
                        handlers.get(hnd).accept((Player)player, pkt.nbt);
                    }
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class PacketNbtNotifyServerToClient {
        public static final Map<String, Consumer<CompoundTag>> handlers = new HashMap<String, Consumer<CompoundTag>>();
        final CompoundTag nbt;

        public static void sendToPlayer(Player player, CompoundTag nbt) {
            if (!(player instanceof ServerPlayer) || player instanceof FakePlayer || nbt == null) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new PacketNbtNotifyServerToClient(nbt), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }

        public static void sendToPlayers(Level world, CompoundTag nbt) {
            for (Player player : world.m_6907_()) {
                PacketNbtNotifyServerToClient.sendToPlayer(player, nbt);
            }
        }

        public PacketNbtNotifyServerToClient(CompoundTag nbt) {
            this.nbt = nbt;
        }

        public static PacketNbtNotifyServerToClient parse(FriendlyByteBuf buf) {
            return new PacketNbtNotifyServerToClient(buf.m_130260_());
        }

        public static void compose(PacketNbtNotifyServerToClient pkt, FriendlyByteBuf buf) {
            buf.m_130079_(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketNbtNotifyServerToClient pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    String hnd = pkt.nbt.m_128461_("hnd");
                    if (hnd.isEmpty()) {
                        return;
                    }
                    if (handlers.containsKey(hnd)) {
                        handlers.get(hnd).accept(pkt.nbt);
                    }
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class OverlayTextMessage {
        public static final int DISPLAY_TIME_MS = 3000;
        private static BiConsumer<Component, Integer> handler_ = null;
        private final Component data_;
        private int delay_ = 3000;

        private Component data() {
            return this.data_;
        }

        private int delay() {
            return this.delay_;
        }

        public static void setHandler(BiConsumer<Component, Integer> handler) {
            if (handler_ == null) {
                handler_ = handler;
            }
        }

        public static void sendToPlayer(Player player, Component message, int delay) {
            if (!(player instanceof ServerPlayer) || player instanceof FakePlayer || Auxiliaries.isEmpty(message)) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new OverlayTextMessage(message, delay), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }

        public OverlayTextMessage() {
            this.data_ = Component.m_237115_((String)"[unset]");
        }

        public OverlayTextMessage(Component tct, int delay) {
            this.data_ = tct.m_6881_();
            this.delay_ = delay;
        }

        public static OverlayTextMessage parse(FriendlyByteBuf buf) {
            try {
                return new OverlayTextMessage(buf.m_130238_(), 3000);
            }
            catch (Throwable e) {
                return new OverlayTextMessage((Component)Component.m_237115_((String)"[incorrect translation]"), 3000);
            }
        }

        public static void compose(OverlayTextMessage pkt, FriendlyByteBuf buf) {
            try {
                buf.m_130083_(pkt.data());
            }
            catch (Throwable e) {
                Auxiliaries.logger().error("OverlayTextMessage.toBytes() failed: " + e);
            }
        }

        public static class Handler {
            public static void handle(OverlayTextMessage pkt, Supplier<NetworkEvent.Context> ctx) {
                if (handler_ != null) {
                    ctx.get().enqueueWork(() -> handler_.accept(pkt.data(), pkt.delay()));
                }
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static interface INetworkSynchronisableContainer {
        public void onServerPacketReceived(int var1, CompoundTag var2);

        public void onClientPacketReceived(int var1, Player var2, CompoundTag var3);
    }

    public static interface IPacketTileNotifyReceiver {
        default public void onServerPacketReceived(CompoundTag nbt) {
        }

        default public void onClientPacketReceived(Player player, CompoundTag nbt) {
        }
    }
}

