/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.libmc;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import wile.wilescollection.libmc.Networking;

public class Overlay {
    public static void show(Player player, Component message) {
        Networking.OverlayTextMessage.sendToPlayer(player, message, 3000);
    }

    public static void show(Player player, Component message, int delay) {
        Networking.OverlayTextMessage.sendToPlayer(player, message, delay);
    }

    public static void show(BlockState state, BlockPos pos) {
        Overlay.show(state, pos, 100);
    }

    public static void show(BlockState state, BlockPos pos, int displayTimeoutMs) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> TextOverlayGui.show(state, pos, displayTimeoutMs));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TextOverlayGui
    extends Screen {
        public static final TextOverlayGui INSTANCE = new TextOverlayGui();
        private static final Component EMPTY_TEXT = Component.m_237113_((String)"");
        private static final BlockState EMPTY_STATE = null;
        private static double overlay_y_ = 0.75;
        private static int text_color_ = 0xFFAA00;
        private static int border_color_ = -1439485133;
        private static int background_color1_ = -1439485133;
        private static int background_color2_ = -1438366652;
        private static long text_deadline_ = 0L;
        private static Component text_ = EMPTY_TEXT;
        private static long state_deadline_ = 0L;
        @Nullable
        private static BlockState state_ = EMPTY_STATE;
        private static BlockPos pos_ = BlockPos.f_121853_;

        public static void on_config(double overlay_y) {
            TextOverlayGui.on_config(overlay_y, 0xFFAA00, -1439485133, -1439485133, -1438366652);
        }

        public static void on_config(double overlay_y, int text_color, int border_color, int background_color1, int background_color2) {
            overlay_y_ = overlay_y;
            text_color_ = text_color;
            border_color_ = border_color;
            background_color1_ = background_color1;
            background_color2_ = background_color2;
        }

        public static synchronized Component text() {
            return text_;
        }

        public static synchronized long deadline() {
            return text_deadline_;
        }

        public static synchronized void hide() {
            text_deadline_ = 0L;
            text_ = EMPTY_TEXT;
        }

        public static synchronized void show(Component s, int displayTimeoutMs) {
            text_ = s == null ? EMPTY_TEXT : s.m_6881_();
            text_deadline_ = System.currentTimeMillis() + (long)displayTimeoutMs;
        }

        public static synchronized void show(String s, int displayTimeoutMs) {
            text_ = s == null || s.isEmpty() ? EMPTY_TEXT : Component.m_237113_((String)s);
            text_deadline_ = System.currentTimeMillis() + (long)displayTimeoutMs;
        }

        public static synchronized void show(BlockState state, BlockPos pos, int displayTimeoutMs) {
            pos_ = new BlockPos((Vec3i)pos);
            state_ = state;
            state_deadline_ = System.currentTimeMillis() + (long)displayTimeoutMs;
        }

        private static synchronized Optional<Tuple<BlockState, BlockPos>> state_pos() {
            return state_deadline_ < System.currentTimeMillis() || state_ == EMPTY_STATE ? Optional.empty() : Optional.of(new Tuple((Object)state_, (Object)pos_));
        }

        TextOverlayGui() {
            super((Component)Component.m_237113_((String)""));
        }

        public void onRenderGui(GuiGraphics gg) {
            if (TextOverlayGui.deadline() < System.currentTimeMillis()) {
                return;
            }
            if (TextOverlayGui.text() == EMPTY_TEXT) {
                return;
            }
            String txt = TextOverlayGui.text().getString();
            if (txt.isEmpty()) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            Window win = mc.m_91268_();
            Font fr = mc.f_91062_;
            boolean was_unicode = fr.m_92718_();
            int cx = win.m_85445_() / 2;
            int cy = (int)((double)win.m_85446_() * overlay_y_);
            int w = fr.m_92895_(txt);
            Objects.requireNonNull(fr);
            int h = 9;
            gg.m_280024_(cx - w / 2 - 3, cy - 2, cx + w / 2 + 2, cy + h + 2, -1439485133, -1438366652);
            gg.m_280656_(cx - w / 2 - 3, cx + w / 2 + 2, cy - 2, -1439485133);
            gg.m_280656_(cx - w / 2 - 3, cx + w / 2 + 2, cy + h + 2, -1439485133);
            gg.m_280315_(cx - w / 2 - 3, cy - 2, cy + h + 2, -1439485133);
            gg.m_280315_(cx + w / 2 + 2, cy - 2, cy + h + 2, -1439485133);
            gg.m_280653_(fr, TextOverlayGui.text(), cx, cy + 1, 0xFFAA00);
        }

        public void onRenderWorldOverlay(PoseStack mxs, double partialTick) {
            Optional<Tuple<BlockState, BlockPos>> sp = TextOverlayGui.state_pos();
            if (sp.isEmpty()) {
                return;
            }
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null || world == null) {
                return;
            }
            BlockState state = (BlockState)sp.get().m_14418_();
            BlockPos pos = (BlockPos)sp.get().m_14419_();
            int light = world.m_46805_(pos) ? LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, pos), (int)world.m_45517_(LightLayer.SKY, pos)) : LightTexture.m_109885_((int)15, (int)15);
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            double px = Mth.m_14139_((double)partialTick, (double)player.f_19854_, (double)player.m_20185_());
            double py = Mth.m_14139_((double)partialTick, (double)player.f_19855_, (double)player.m_20186_());
            double pz = Mth.m_14139_((double)partialTick, (double)player.f_19856_, (double)player.m_20189_());
            mxs.m_85836_();
            mxs.m_85837_((double)pos.m_123341_() - px, (double)pos.m_123342_() - py - (double)player.m_20192_(), (double)pos.m_123343_() - pz);
            Minecraft.m_91087_().m_91289_().m_110912_(state, mxs, (MultiBufferSource)buffer, light, OverlayTexture.f_118083_);
            mxs.m_85849_();
        }
    }
}

