/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.libmc.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.wilescollection.libmc.Auxiliaries;
import wile.wilescollection.libmc.blocks.StandardBlocks;

public class StandardDoorBlock
extends DoorBlock
implements StandardBlocks.IStandardBlock {
    private final long config_;
    private final boolean players_only_;
    protected final VoxelShape[][][][] shapes_;
    protected final VoxelShape[][][][] collision_shapes_;
    protected final SoundEvent open_sound_;
    protected final SoundEvent close_sound_;

    public StandardDoorBlock(long config, BlockBehaviour.Properties properties, BlockSetType settype, AABB[] open_aabbs_top, AABB[] open_aabbs_bottom, AABB[] closed_aabbs_top, AABB[] closed_aabbs_bottom, SoundEvent open_sound, SoundEvent close_sound, boolean players_only) {
        super(properties, settype);
        VoxelShape[][][][] shapes = new VoxelShape[Direction.values().length][2][2][2];
        VoxelShape[][][][] collision_shapes = new VoxelShape[Direction.values().length][2][2][2];
        for (Direction facing : Direction.values()) {
            for (boolean open : new boolean[]{false, true}) {
                for (DoubleBlockHalf half : new DoubleBlockHalf[]{DoubleBlockHalf.UPPER, DoubleBlockHalf.LOWER}) {
                    for (boolean hinge_right : new boolean[]{false, true}) {
                        VoxelShape shape = Shapes.m_83040_();
                        VoxelShape collision_shape = Shapes.m_83040_();
                        if (facing.m_122434_() == Direction.Axis.Y) {
                            shape = Shapes.m_83144_();
                        } else {
                            AABB[] aabbs;
                            for (AABB e : aabbs = open ? (half == DoubleBlockHalf.UPPER ? open_aabbs_top : open_aabbs_bottom) : (half == DoubleBlockHalf.UPPER ? closed_aabbs_top : closed_aabbs_bottom)) {
                                AABB aabb = Auxiliaries.getRotatedAABB(e, facing, true);
                                if (!hinge_right) {
                                    aabb = Auxiliaries.getMirroredAABB(aabb, facing.m_122427_().m_122434_());
                                }
                                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82695_);
                                collision_shape = half == DoubleBlockHalf.UPPER ? shape : Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)aabb.m_165893_(aabb.f_82292_ + 4.0)), (BooleanOp)BooleanOp.f_82695_);
                            }
                        }
                        shapes[facing.ordinal()][open ? 1 : 0][hinge_right ? 1 : 0][half == DoubleBlockHalf.UPPER ? 0 : 1] = shape;
                        collision_shapes[facing.ordinal()][open ? 1 : 0][hinge_right ? 1 : 0][half == DoubleBlockHalf.UPPER ? 0 : 1] = collision_shape;
                    }
                }
            }
        }
        this.config_ = config;
        this.shapes_ = shapes;
        this.collision_shapes_ = collision_shapes;
        this.open_sound_ = open_sound;
        this.close_sound_ = close_sound;
        this.players_only_ = players_only;
    }

    public StandardDoorBlock(long config, BlockBehaviour.Properties properties, BlockSetType settype, AABB open_aabb, AABB closed_aabb, SoundEvent open_sound, SoundEvent close_sound, boolean players_only) {
        this(config, properties, settype, new AABB[]{open_aabb}, new AABB[]{open_aabb}, new AABB[]{closed_aabb}, new AABB[]{closed_aabb}, open_sound, close_sound, players_only);
    }

    public StandardDoorBlock(long config, BlockBehaviour.Properties properties, BlockSetType settype, SoundEvent open_sound, SoundEvent close_sound) {
        this(config, properties, settype, Auxiliaries.getPixeledAABB(13.0, 0.0, 0.0, 16.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 13.0, 16.0, 16.0, 16.0), open_sound, close_sound, false);
    }

    public StandardDoorBlock(long config, BlockBehaviour.Properties properties, BlockSetType settype) {
        this(config, properties, settype, Auxiliaries.getPixeledAABB(13.0, 0.0, 0.0, 16.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 13.0, 16.0, 16.0, 16.0), SoundEvents.f_12627_, SoundEvents.f_12626_, false);
    }

    @Override
    public long config() {
        return this.config_;
    }

    protected void sound(BlockGetter world, BlockPos pos, boolean open) {
        if (world instanceof Level) {
            ((Level)world).m_5594_(null, pos, open ? this.open_sound_ : this.close_sound_, SoundSource.BLOCKS, 0.7f, 1.0f);
        }
    }

    protected void actuate_adjacent_wing(BlockState state, BlockGetter world_ro, BlockPos pos, boolean open) {
        if (!(world_ro instanceof Level)) {
            return;
        }
        Level world = (Level)world_ro;
        BlockPos adjecent_pos = pos.m_121945_(state.m_61143_((Property)f_52728_) == DoorHingeSide.LEFT ? ((Direction)state.m_61143_((Property)f_52726_)).m_122427_() : ((Direction)state.m_61143_((Property)f_52726_)).m_122428_());
        if (!world.m_46749_(adjecent_pos)) {
            return;
        }
        BlockState adjacent_state = world.m_8055_(adjecent_pos);
        if (adjacent_state.m_60734_() != this) {
            return;
        }
        if ((Boolean)adjacent_state.m_61143_((Property)f_52727_) == open) {
            return;
        }
        BlockPos adjecent_half_pos = adjacent_state.m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER ? adjecent_pos.m_7495_() : adjecent_pos.m_7494_();
        world.m_7731_(adjecent_pos, (BlockState)adjacent_state.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(open)), 3);
        world.m_7731_(adjecent_half_pos, (BlockState)world.m_8055_(adjecent_half_pos).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(open)), 3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    public boolean m_48673_(BlockState state) {
        return false;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType path) {
        return this.players_only_ ? false : super.m_7357_(state, world, pos, path);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shapes_[((Direction)state.m_61143_((Property)f_52726_)).ordinal()][(Boolean)state.m_61143_((Property)f_52727_) != false ? 1 : 0][state.m_61143_((Property)f_52728_) == DoorHingeSide.RIGHT ? 1 : 0][state.m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER ? 0 : 1];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.collision_shapes_[((Direction)state.m_61143_((Property)f_52726_)).ordinal()][(Boolean)state.m_61143_((Property)f_52727_) != false ? 1 : 0][state.m_61143_((Property)f_52728_) == DoorHingeSide.RIGHT ? 1 : 0][state.m_61143_((Property)f_52730_) == DoubleBlockHalf.UPPER ? 0 : 1];
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        this.setDoubleOpen((Entity)player, world, state, pos, (Boolean)state.m_61143_((Property)f_52727_) == false);
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        boolean bl = world.m_276867_(pos) || world.m_276867_(pos.m_121945_(state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (powered = false);
        if (block == this || powered == (Boolean)state.m_61143_((Property)f_52729_)) {
            return;
        }
        world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(powered)), 10);
        this.actuate_adjacent_wing(state, (BlockGetter)world, pos, powered);
        if (powered != (Boolean)state.m_61143_((Property)f_52727_)) {
            this.sound((BlockGetter)world, pos, powered);
        }
    }

    public void m_153165_(@Nullable Entity entity, Level world, BlockState state, BlockPos pos, boolean open) {
        if (!this.players_only_ || entity instanceof Player) {
            super.m_153165_(entity, world, state, pos, open);
        }
    }

    protected void setDoubleOpen(@Nullable Entity entity, Level world, BlockState state, BlockPos pos, boolean open) {
        if (this.players_only_ && !(entity instanceof Player)) {
            return;
        }
        if (!state.m_60713_((Block)this) || (Boolean)state.m_61143_((Property)f_52727_) == open) {
            return;
        }
        state = (BlockState)state.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(open));
        world.m_7731_(pos, state, 10);
        this.sound((BlockGetter)world, pos, open);
        this.actuate_adjacent_wing(state, (BlockGetter)world, pos, open);
        world.m_142346_(entity, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
    }
}

