/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.libmc.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.wilescollection.libmc.Auxiliaries;
import wile.wilescollection.libmc.blocks.StandardBlocks;
import wile.wilescollection.libmc.blocks.VariantWallBlock;

public class StandardFenceBlock
extends WallBlock
implements StandardBlocks.IStandardBlock {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final EnumProperty<WallSide> WALL_EAST = BlockStateProperties.f_61378_;
    public static final EnumProperty<WallSide> WALL_NORTH = BlockStateProperties.f_61379_;
    public static final EnumProperty<WallSide> WALL_SOUTH = BlockStateProperties.f_61380_;
    public static final EnumProperty<WallSide> WALL_WEST = BlockStateProperties.f_61381_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Map<BlockState, VoxelShape> shape_voxels;
    private final Map<BlockState, VoxelShape> collision_shape_voxels;
    private final long config;

    public StandardFenceBlock(long config, BlockBehaviour.Properties properties) {
        this(config, properties, 1.5, 16.0, 1.5, 0.0, 14.0, 16.0);
    }

    public StandardFenceBlock(long config, BlockBehaviour.Properties properties, double pole_width, double pole_height, double side_width, double side_min_y, double side_max_low_y, double side_max_tall_y) {
        super(properties);
        this.shape_voxels = this.buildShapes(pole_width, pole_height, side_width, side_min_y, side_max_low_y, side_max_tall_y);
        this.collision_shape_voxels = this.buildShapes(pole_width, 24.0, pole_width, 0.0, 24.0, 24.0);
        this.config = config;
    }

    @Override
    public long config() {
        return this.config;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    private static VoxelShape combinedShape(VoxelShape pole, WallSide height, VoxelShape low, VoxelShape high) {
        if (height == WallSide.TALL) {
            return Shapes.m_83110_((VoxelShape)pole, (VoxelShape)high);
        }
        if (height == WallSide.LOW) {
            return Shapes.m_83110_((VoxelShape)pole, (VoxelShape)low);
        }
        return pole;
    }

    protected Map<BlockState, VoxelShape> buildShapes(double pole_width, double pole_height, double side_width, double side_min_y, double side_max_low_y, double side_max_tall_y) {
        double px0 = 8.0 - pole_width;
        double px1 = 8.0 + pole_width;
        double sx0 = 8.0 - side_width;
        double sx1 = 8.0 + side_width;
        VoxelShape vp = Block.m_49796_((double)px0, (double)0.0, (double)px0, (double)px1, (double)pole_height, (double)px1);
        VoxelShape vs1 = Block.m_49796_((double)sx0, (double)side_min_y, (double)0.0, (double)sx1, (double)side_max_low_y, (double)sx1);
        VoxelShape vs2 = Block.m_49796_((double)sx0, (double)side_min_y, (double)sx0, (double)sx1, (double)side_max_low_y, (double)16.0);
        VoxelShape vs3 = Block.m_49796_((double)0.0, (double)side_min_y, (double)sx0, (double)sx1, (double)side_max_low_y, (double)sx1);
        VoxelShape vs4 = Block.m_49796_((double)sx0, (double)side_min_y, (double)sx0, (double)16.0, (double)side_max_low_y, (double)sx1);
        VoxelShape vs5 = Block.m_49796_((double)sx0, (double)side_min_y, (double)0.0, (double)sx1, (double)side_max_tall_y, (double)sx1);
        VoxelShape vs6 = Block.m_49796_((double)sx0, (double)side_min_y, (double)sx0, (double)sx1, (double)side_max_tall_y, (double)16.0);
        VoxelShape vs7 = Block.m_49796_((double)0.0, (double)side_min_y, (double)sx0, (double)sx1, (double)side_max_tall_y, (double)sx1);
        VoxelShape vs8 = Block.m_49796_((double)sx0, (double)side_min_y, (double)sx0, (double)16.0, (double)side_max_tall_y, (double)sx1);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean up : UP.m_6908_()) {
            for (WallSide wh_east : WALL_EAST.m_6908_()) {
                for (WallSide wh_north : WALL_NORTH.m_6908_()) {
                    for (WallSide wh_west : WALL_WEST.m_6908_()) {
                        for (WallSide wh_south : WALL_SOUTH.m_6908_()) {
                            VoxelShape shape = Shapes.m_83040_();
                            shape = StandardFenceBlock.combinedShape(shape, wh_east, vs4, vs8);
                            shape = StandardFenceBlock.combinedShape(shape, wh_west, vs3, vs7);
                            shape = StandardFenceBlock.combinedShape(shape, wh_north, vs1, vs5);
                            shape = StandardFenceBlock.combinedShape(shape, wh_south, vs2, vs6);
                            if (up.booleanValue()) {
                                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)vp);
                            }
                            BlockState bs = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)up)).m_61124_(WALL_EAST, (Comparable)wh_east)).m_61124_(WALL_NORTH, (Comparable)wh_north)).m_61124_(WALL_WEST, (Comparable)wh_west)).m_61124_(WALL_SOUTH, (Comparable)wh_south);
                            builder.put((Object)((BlockState)bs.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)shape);
                            builder.put((Object)((BlockState)bs.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)shape);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.shape_voxels.getOrDefault(state, Shapes.m_83144_());
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.collision_shape_voxels.getOrDefault(state, Shapes.m_83144_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }

    protected boolean attachesTo(BlockState facingState, LevelReader world, BlockPos facingPos, Direction side) {
        Block block = facingState.m_60734_();
        if (block instanceof FenceGateBlock || block instanceof StandardFenceBlock || block instanceof VariantWallBlock) {
            return true;
        }
        BlockState oppositeState = world.m_8055_(facingPos.m_5484_(side, 2));
        if (!(oppositeState.m_60734_() instanceof StandardFenceBlock)) {
            return false;
        }
        return facingState.m_60796_((BlockGetter)world, facingPos) && StandardFenceBlock.m_49863_((LevelReader)world, (BlockPos)facingPos, (Direction)side);
    }

    protected WallSide selectWallHeight(LevelReader world, BlockPos pos, Direction direction) {
        return WallSide.LOW;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState fs = context.m_43725_().m_6425_(context.m_8083_());
        boolean n = this.attachesTo(world.m_8055_(pos.m_122012_()), (LevelReader)world, pos.m_122012_(), Direction.SOUTH);
        boolean e = this.attachesTo(world.m_8055_(pos.m_122029_()), (LevelReader)world, pos.m_122029_(), Direction.WEST);
        boolean s = this.attachesTo(world.m_8055_(pos.m_122019_()), (LevelReader)world, pos.m_122019_(), Direction.NORTH);
        boolean w = this.attachesTo(world.m_8055_(pos.m_122024_()), (LevelReader)world, pos.m_122024_(), Direction.EAST);
        boolean not_straight = !(n && s && !e && !w || !n && !s && e && w);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(not_straight))).m_61124_(WALL_NORTH, (Comparable)(n ? this.selectWallHeight((LevelReader)world, pos, Direction.NORTH) : WallSide.NONE))).m_61124_(WALL_EAST, (Comparable)(e ? this.selectWallHeight((LevelReader)world, pos, Direction.EAST) : WallSide.NONE))).m_61124_(WALL_SOUTH, (Comparable)(s ? this.selectWallHeight((LevelReader)world, pos, Direction.SOUTH) : WallSide.NONE))).m_61124_(WALL_WEST, (Comparable)(w ? this.selectWallHeight((LevelReader)world, pos, Direction.WEST) : WallSide.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction side, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        boolean s;
        boolean e;
        boolean n;
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (side == Direction.DOWN) {
            return super.m_7417_(state, side, facingState, world, pos, facingPos);
        }
        boolean bl = side == Direction.NORTH ? this.attachesTo(facingState, (LevelReader)world, facingPos, side) : (n = state.m_61143_(WALL_NORTH) != WallSide.NONE);
        boolean bl2 = side == Direction.EAST ? this.attachesTo(facingState, (LevelReader)world, facingPos, side) : (e = state.m_61143_(WALL_EAST) != WallSide.NONE);
        boolean bl3 = side == Direction.SOUTH ? this.attachesTo(facingState, (LevelReader)world, facingPos, side) : (s = state.m_61143_(WALL_SOUTH) != WallSide.NONE);
        boolean w = side == Direction.WEST ? this.attachesTo(facingState, (LevelReader)world, facingPos, side) : state.m_61143_(WALL_WEST) != WallSide.NONE;
        boolean not_straight = !(n && s && !e && !w || !n && !s && e && w);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(not_straight))).m_61124_(WALL_NORTH, (Comparable)(n ? this.selectWallHeight((LevelReader)world, pos, Direction.NORTH) : WallSide.NONE))).m_61124_(WALL_EAST, (Comparable)(e ? this.selectWallHeight((LevelReader)world, pos, Direction.EAST) : WallSide.NONE))).m_61124_(WALL_SOUTH, (Comparable)(s ? this.selectWallHeight((LevelReader)world, pos, Direction.SOUTH) : WallSide.NONE))).m_61124_(WALL_WEST, (Comparable)(w ? this.selectWallHeight((LevelReader)world, pos, Direction.WEST) : WallSide.NONE));
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public boolean m_48673_(BlockState state) {
        return false;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.NORMAL;
    }
}

