/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.morebuckets.crafting.condition;

import com.blakebr0.morebuckets.bucket.Bucket;
import com.blakebr0.morebuckets.lib.ModBuckets;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class BucketEnabledCondition
implements ICondition {
    private static final ResourceLocation ID = new ResourceLocation("morebuckets", "bucket_enabled");
    private final ResourceLocation bucket;

    public BucketEnabledCondition(ResourceLocation bucket) {
        this.bucket = bucket;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        Bucket bucket = ModBuckets.ALL.get(this.bucket);
        return bucket != null && bucket.isEnabled();
    }

    public static class Serializer
    implements IConditionSerializer<BucketEnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, BucketEnabledCondition value) {
            json.addProperty("bucket", value.bucket.toString());
        }

        public BucketEnabledCondition read(JsonObject json) {
            String crop = GsonHelper.m_13906_((JsonObject)json, (String)"bucket");
            return new BucketEnabledCondition(new ResourceLocation(crop));
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

