/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.morebuckets.crafting.ingredient;

import com.blakebr0.cucumber.helper.FluidHelper;
import com.blakebr0.morebuckets.crafting.RecipeFixer;
import com.blakebr0.morebuckets.init.ModRecipeSerializers;
import com.blakebr0.morebuckets.item.MoreBucketItem;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class FluidIngredient
extends Ingredient {
    private final Ingredient parent;

    public FluidIngredient(Ingredient parent) {
        super(FluidIngredient.makeMatchingStacksArray(parent));
        this.parent = parent;
    }

    public boolean test(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Optional fluid = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluid.isPresent() && stack.m_41720_() instanceof MoreBucketItem) {
            for (ItemStack itemstack : this.m_43908_()) {
                Optional fluidstack = FluidUtil.getFluidContained((ItemStack)itemstack);
                if (!fluidstack.isPresent() || !((FluidStack)fluidstack.get()).isFluidEqual((FluidStack)fluid.get())) continue;
                return true;
            }
        }
        return this.parent.test(stack);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return ModRecipeSerializers.FLUID_INGREDIENT;
    }

    private static Stream<? extends Ingredient.Value> makeMatchingStacksArray(Ingredient ingredient) {
        FluidStack fluid = FluidIngredient.findFluid(ingredient);
        if (fluid != null) {
            ItemStack[] parentStacks = ingredient.m_43908_();
            ItemStack[] bucketStacks = (ItemStack[])RecipeFixer.VALID_BUCKETS.stream().map(e -> FluidHelper.getFilledBucket((FluidStack)fluid, (Item)e, (int)e.getCapacity(ItemStack.f_41583_))).toArray(ItemStack[]::new);
            ItemStack[] matchingStacks = new ItemStack[parentStacks.length + bucketStacks.length];
            for (int i = 0; i < parentStacks.length; ++i) {
                matchingStacks[i] = parentStacks[i];
            }
            for (int j = parentStacks.length; j < matchingStacks.length; ++j) {
                matchingStacks[j] = bucketStacks[j - parentStacks.length];
            }
            return Arrays.stream(matchingStacks).map(Ingredient.ItemValue::new);
        }
        return Stream.of(ingredient.f_43902_);
    }

    private static FluidStack findFluid(Ingredient ingredient) {
        for (ItemStack stack : ingredient.m_43908_()) {
            Optional fluid = FluidUtil.getFluidContained((ItemStack)stack);
            if (!fluid.isPresent()) continue;
            return (FluidStack)fluid.get();
        }
        return null;
    }

    public static class Serializer
    implements IIngredientSerializer<FluidIngredient> {
        public FluidIngredient parse(FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43938_(Stream.generate(() -> new Ingredient.ItemValue(buffer.m_130267_())).limit(buffer.m_130242_()));
            return new FluidIngredient(ingredient);
        }

        public FluidIngredient parse(JsonObject json) {
            Ingredient ingredient = Ingredient.m_43938_(Stream.of(Ingredient.m_43919_((JsonObject)json)));
            return new FluidIngredient(ingredient);
        }

        public void write(FriendlyByteBuf buffer, FluidIngredient ingredient) {
            ItemStack[] items = ingredient.m_43908_();
            buffer.m_130130_(items.length);
            for (ItemStack stack : items) {
                buffer.m_130055_(stack);
            }
        }
    }
}

