/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.morebuckets.item;

import com.blakebr0.cucumber.fluid.FluidHolderItemWrapper;
import com.blakebr0.cucumber.helper.FluidHelper;
import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.iface.IFluidHolder;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.morebuckets.bucket.Bucket;
import com.blakebr0.morebuckets.lib.ModTooltips;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class MoreBucketItem
extends BaseItem
implements IFluidHolder {
    public static final List<MoreBucketItem> BUCKETS = new ArrayList<MoreBucketItem>();
    private final Bucket bucket;

    public MoreBucketItem(Bucket bucket) {
        this.bucket = bucket;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new DispenserBehavior());
        BUCKETS.add(this);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return FluidHelper.getFluidAmount((ItemStack)stack) > 0;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        ItemStack copy = new ItemStack((ItemLike)this);
        copy.m_41751_(stack.m_41783_());
        this.drain(copy, 1000, true);
        return copy;
    }

    public int m_142158_(ItemStack stack) {
        int capacity = this.getCapacity(stack);
        int stored = capacity - FluidHelper.getFluidAmount((ItemStack)stack);
        return Math.round(13.0f - (float)stored * 13.0f / (float)capacity);
    }

    public int m_142159_(ItemStack stack) {
        int capacity = this.getCapacity(stack);
        int stored = FluidHelper.getFluidAmount((ItemStack)stack);
        float f = Math.max(0.0f, (float)stored / (float)capacity);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getCapacity(stack) > 1000;
    }

    public int getBurnTime(ItemStack stack, RecipeType<?> type) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.isFluidEqual(new FluidStack((Fluid)Fluids.f_76195_, 1000)) && FluidHelper.getFluidAmount((ItemStack)stack) >= 1000) {
            return 20000;
        }
        return -1;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        MutableComponent capacity = Formatting.number((Object)this.bucket.getBuckets());
        int buckets = FluidHelper.getFluidAmount((ItemStack)stack) / 1000;
        FluidStack fluid = FluidHelper.getFluidFromStack((ItemStack)stack);
        if (fluid.isEmpty()) {
            tooltip.add((Component)ModTooltips.BUCKETS.args(new Object[]{buckets, capacity, ModTooltips.EMPTY.build()}).build());
        } else {
            tooltip.add((Component)ModTooltips.BUCKETS.args(new Object[]{buckets, capacity, fluid.getDisplayName()}).build());
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        FluidStack fluid = this.getFluid(stack);
        InteractionResultHolder<ItemStack> pickup = this.tryPickupFluid(stack, level, player, hand);
        if (pickup.m_19089_() == InteractionResult.SUCCESS) {
            return pickup;
        }
        if (fluid != null && fluid.getAmount() >= 1000) {
            return this.tryPlaceFluid(stack, level, player, hand);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new FluidHolderItemWrapper(stack, (IFluidHolder)this);
    }

    public int getCapacity(ItemStack stack) {
        return this.bucket.getCapacity();
    }

    public FluidStack getFluid(ItemStack stack) {
        return FluidHelper.getFluidFromStack((ItemStack)stack);
    }

    public int fill(ItemStack stack, FluidStack fluid, boolean canFill) {
        NBTHelper.validateCompound((ItemStack)stack);
        FluidStack bucketFluid = this.getFluid(stack);
        if (!bucketFluid.isEmpty() && !fluid.isFluidEqual(bucketFluid)) {
            return 0;
        }
        int capacity = this.getCapacity(stack);
        if (!canFill) {
            if (bucketFluid.isEmpty()) {
                return FluidHelper.toBuckets((int)Math.min(capacity, fluid.getAmount()));
            }
            return FluidHelper.toBuckets((int)Math.min(capacity - bucketFluid.getAmount(), fluid.getAmount()));
        }
        int filled = FluidHelper.toBuckets((int)Math.min(fluid.getAmount(), capacity));
        if (bucketFluid.isEmpty()) {
            CompoundTag fluidTag = fluid.writeToNBT(new CompoundTag());
            fluidTag.m_128405_("Amount", filled);
            stack.m_41751_(fluidTag);
            return filled;
        }
        filled = FluidHelper.toBuckets((int)(capacity - bucketFluid.getAmount()));
        int amount = FluidHelper.toBuckets((int)fluid.getAmount());
        if (amount < filled) {
            bucketFluid.grow(amount);
            filled = amount;
        } else {
            bucketFluid.setAmount(capacity);
        }
        bucketFluid.writeToNBT(stack.m_41783_());
        return filled;
    }

    public FluidStack drain(ItemStack stack, int amount, boolean canDrain) {
        NBTHelper.validateCompound((ItemStack)stack);
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = this.getFluid(stack);
        if (fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int drained = FluidHelper.toBuckets((int)Math.min(fluid.getAmount(), amount));
        if (canDrain) {
            if (amount >= fluid.getAmount()) {
                NBTHelper.removeTag((ItemStack)stack, (String)"FluidName");
                NBTHelper.removeTag((ItemStack)stack, (String)"Amount");
                return fluid;
            }
            fluid.shrink(drained);
            fluid.writeToNBT(stack.m_41783_());
        }
        fluid.setAmount(drained);
        return fluid;
    }

    public int getSpaceLeft(ItemStack stack) {
        return this.getCapacity(stack) - FluidHelper.getFluidAmount((ItemStack)stack);
    }

    public boolean isEnabled() {
        return this.bucket.isEnabled();
    }

    private InteractionResultHolder<ItemStack> tryPlaceFluid(ItemStack stack, Level level, Player player, InteractionHand hand) {
        FluidActionResult result;
        BlockPos targetPos;
        if (FluidHelper.getFluidAmount((ItemStack)stack) < 1000) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockHitResult trace = MoreBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (trace.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos pos = trace.m_82425_();
        if (level.m_7966_(player, pos) && player.m_36204_(targetPos = pos.m_121945_(trace.m_82434_()), trace.m_82434_().m_122424_(), stack) && (result = FluidUtil.tryPlaceFluid((Player)player, (Level)level, (InteractionHand)hand, (BlockPos)targetPos, (ItemStack)stack, (FluidStack)new FluidStack(this.getFluid(stack), 1000))).isSuccess() && !player.m_150110_().f_35937_) {
            if (!level.m_5776_()) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, stack);
            }
            return InteractionResultHolder.m_19090_((Object)result.getResult());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private InteractionResultHolder<ItemStack> tryPickupFluid(ItemStack stack, Level level, Player player, InteractionHand hand) {
        FluidActionResult result;
        Direction direction;
        if (this.getSpaceLeft(stack) < 1000) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockHitResult trace = MoreBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (trace.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos pos = trace.m_82425_();
        if (level.m_7966_(player, pos) && player.m_36204_(pos, direction = trace.m_82434_(), stack) && (result = FluidUtil.tryPickUpFluid((ItemStack)stack, (Player)player, (Level)level, (BlockPos)pos, (Direction)direction)).isSuccess() && !player.m_150110_().f_35937_) {
            if (!level.m_5776_()) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, stack);
            }
            return InteractionResultHolder.m_19090_((Object)result.getResult());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private static class DispenserBehavior
    extends OptionalDispenseItemBehavior {
        private DispenserBehavior() {
        }

        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            ServerLevel level = source.m_7727_();
            Direction facing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            BlockPos pos = source.m_7961_().m_121945_(facing);
            FluidActionResult action = FluidUtil.tryPickUpFluid((ItemStack)stack, null, (Level)level, (BlockPos)pos, (Direction)facing.m_122424_());
            ItemStack resultStack = action.getResult();
            if (!action.isSuccess() || resultStack.m_41619_()) {
                FluidActionResult result;
                ItemStack singleStack = StackHelper.withSize((ItemStack)stack, (int)1, (boolean)false);
                Optional fluidHandler = FluidUtil.getFluidHandler((ItemStack)singleStack).resolve();
                if (fluidHandler.isEmpty()) {
                    return super.m_7498_(source, stack);
                }
                FluidStack fluidStack = ((IFluidHandlerItem)fluidHandler.get()).drain(1000, IFluidHandler.FluidAction.EXECUTE);
                FluidActionResult fluidActionResult = result = !fluidStack.isEmpty() ? FluidUtil.tryPlaceFluid(null, (Level)level, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (ItemStack)stack, (FluidStack)fluidStack) : FluidActionResult.FAILURE;
                if (result.isSuccess()) {
                    ItemStack drainedStack = result.getResult();
                    if (drainedStack.m_41613_() == 1) {
                        return drainedStack;
                    }
                    if (!drainedStack.m_41619_() && ((DispenserBlockEntity)source.m_8118_()).m_59237_(drainedStack) < 0) {
                        this.m_6115_(source, drainedStack);
                    }
                    return StackHelper.shrink((ItemStack)drainedStack, (int)1, (boolean)false);
                }
                return this.m_6115_(source, stack);
            }
            if (stack.m_41613_() == 1) {
                return resultStack;
            }
            if (((DispenserBlockEntity)source.m_8118_()).m_59237_(resultStack) < 0) {
                this.m_6115_(source, resultStack);
            }
            return resultStack;
        }
    }
}

