/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.containers.handlers;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import thetadev.constructionwand.api.IContainerHandler;
import thetadev.constructionwand.basics.WandUtil;

public class HandlerShulkerbox
implements IContainerHandler {
    private final int SLOTS = 27;

    @Override
    public boolean matches(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        return inventoryStack != null && inventoryStack.m_41613_() == 1 && Block.m_49814_((Item)inventoryStack.m_41720_()) instanceof ShulkerBoxBlock;
    }

    @Override
    public int countItems(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        int count = 0;
        for (ItemStack stack : this.getItemList(inventoryStack)) {
            if (!WandUtil.stackEquals(stack, itemStack)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    @Override
    public int useItems(Player player, ItemStack itemStack, ItemStack inventoryStack, int count) {
        NonNullList<ItemStack> itemList = this.getItemList(inventoryStack);
        boolean changed = false;
        for (ItemStack stack : itemList) {
            if (!WandUtil.stackEquals(stack, itemStack)) continue;
            int toTake = Math.min(count, stack.m_41613_());
            stack.m_41774_(toTake);
            changed = true;
            if ((count -= toTake) != 0) continue;
            break;
        }
        if (changed) {
            this.setItemList(inventoryStack, itemList);
            player.m_150109_().m_6596_();
        }
        return count;
    }

    private NonNullList<ItemStack> getItemList(ItemStack itemStack) {
        CompoundTag entityTag;
        NonNullList itemStacks = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
        CompoundTag rootTag = itemStack.m_41783_();
        if (rootTag != null && rootTag.m_128425_("BlockEntityTag", 10) && (entityTag = rootTag.m_128469_("BlockEntityTag")).m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)entityTag, (NonNullList)itemStacks);
        }
        return itemStacks;
    }

    private void setItemList(ItemStack itemStack, NonNullList<ItemStack> itemStacks) {
        CompoundTag rootTag = itemStack.m_41784_();
        if (!rootTag.m_128425_("BlockEntityTag", 10)) {
            rootTag.m_128365_("BlockEntityTag", (Tag)new CompoundTag());
        }
        ContainerHelper.m_18973_((CompoundTag)rootTag.m_128469_("BlockEntityTag"), itemStacks);
    }
}

