/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class SawmillRecipeBuilder
extends IEFinishedRecipe<SawmillRecipeBuilder> {
    JsonArray secondaryArray = new JsonArray();

    private SawmillRecipeBuilder() {
        super((IERecipeSerializer)SawmillRecipe.SERIALIZER.get());
        this.addWriter(jsonObject -> jsonObject.add("secondaries", (JsonElement)this.secondaryArray));
    }

    public static SawmillRecipeBuilder builder(Item result) {
        return (SawmillRecipeBuilder)new SawmillRecipeBuilder().addResult((ItemLike)result);
    }

    public static SawmillRecipeBuilder builder(ItemStack result) {
        return (SawmillRecipeBuilder)new SawmillRecipeBuilder().addResult(result);
    }

    public static SawmillRecipeBuilder builder(TagKey<Item> result, int count) {
        return (SawmillRecipeBuilder)new SawmillRecipeBuilder().addResult(new IngredientWithSize(result, count));
    }

    public SawmillRecipeBuilder addStripped(ItemLike itemProvider) {
        return (SawmillRecipeBuilder)this.addItem("stripped", new ItemStack(itemProvider));
    }

    public SawmillRecipeBuilder addStripped(ItemStack itemStack) {
        return (SawmillRecipeBuilder)this.addItem("stripped", itemStack);
    }

    public SawmillRecipeBuilder addStripped(TagKey<Item> tag) {
        return this.addStripped(new IngredientWithSize(tag), new ICondition[0]);
    }

    public SawmillRecipeBuilder addStripped(IngredientWithSize ingredient, ICondition ... conditions) {
        return (SawmillRecipeBuilder)this.addWriter(jsonObject -> jsonObject.add("stripped", ingredient.serialize()));
    }

    public SawmillRecipeBuilder addSecondary(ItemLike itemProvider, boolean stripping) {
        return this.addSecondary(new ItemStack(itemProvider), stripping);
    }

    public SawmillRecipeBuilder addSecondary(ItemStack itemStack, boolean stripping) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("output", (JsonElement)this.serializeItemStack(itemStack));
        jsonObject.addProperty("stripping", Boolean.valueOf(stripping));
        this.secondaryArray.add((JsonElement)jsonObject);
        return this;
    }

    public SawmillRecipeBuilder addSecondary(TagKey<Item> tag, boolean stripping) {
        return this.addSecondary(new IngredientWithSize(tag), stripping, new ICondition[0]);
    }

    public SawmillRecipeBuilder addSecondary(IngredientWithSize ingredient, boolean stripping, ICondition ... conditions) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("output", ingredient.serialize());
        jsonObject.addProperty("stripping", Boolean.valueOf(stripping));
        if (conditions.length > 0) {
            JsonArray conditionArray = new JsonArray();
            for (ICondition condition : conditions) {
                conditionArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            }
            jsonObject.add("conditions", (JsonElement)conditionArray);
        }
        this.secondaryArray.add((JsonElement)jsonObject);
        return this;
    }
}

