/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks.blocks.component;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.utils.ComputerControlState;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;

public class RedstoneControl<S>
implements IMultiblockComponent<RSState>,
IMultiblockComponent.StateWrapper<S, RSState> {
    private final IMultiblockComponent.StateWrapper<S, RSState> getState;
    private final List<BlockPos> positions;
    private final boolean allowComputerControl;

    public RedstoneControl(IMultiblockComponent.StateWrapper<S, RSState> getState, BlockPos ... positions) {
        this(getState, true, positions);
    }

    public RedstoneControl(IMultiblockComponent.StateWrapper<S, RSState> getState, boolean allowComputerControl, BlockPos ... positions) {
        this.positions = Arrays.asList(positions);
        this.getState = s -> {
            RSState rsState = (RSState)getState.wrapState(s);
            rsState.positions = this.positions;
            return rsState;
        };
        this.allowComputerControl = allowComputerControl;
    }

    public boolean allowComputerControl() {
        return this.allowComputerControl;
    }

    @Override
    public RSState wrapState(S outer) {
        return this.getState.wrapState(outer);
    }

    @Override
    public InteractionResult click(IMultiblockContext<RSState> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        ItemStack held = player.m_21120_(hand);
        if (!held.m_204117_(IETags.screwdrivers) || !this.positions.contains(posInMultiblock)) {
            return InteractionResult.PASS;
        }
        if (!isClient) {
            boolean inverted;
            ctx.getState().rsEnablesMachine = inverted = !ctx.getState().rsEnablesMachine;
            player.m_5661_((Component)Component.m_237115_((String)("chat.immersiveengineering.info.rsControl." + (inverted ? "invertedOn" : "invertedOff"))), true);
            ctx.markMasterDirty();
        }
        return InteractionResult.SUCCESS;
    }

    public static class RSState
    implements IMultiblockState {
        private boolean rsEnablesMachine;
        private List<BlockPos> positions = List.of();
        private final ComputerControlState computerControlState = new ComputerControlState();

        public static RSState enabledByDefault() {
            return new RSState(false);
        }

        public static RSState disabledByDefault() {
            return new RSState(true);
        }

        private RSState(boolean rsEnablesMachine) {
            this.rsEnablesMachine = rsEnablesMachine;
        }

        public boolean isEnabled(IMultiblockContext<?> ctx) {
            if (this.computerControlState.isAttached() && !this.computerControlState.isEnabled()) {
                return false;
            }
            for (BlockPos rsPos : this.positions) {
                boolean hasRS = ctx.getRedstoneInputValue(rsPos, 0) > 0;
                if (this.rsEnablesMachine != hasRS) continue;
                return true;
            }
            return false;
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128379_("rsEnablesMachine", this.rsEnablesMachine);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.rsEnablesMachine = nbt.m_128471_("rsEnablesMachine");
        }

        public ComputerControlState getComputerControlState() {
            return this.computerControlState;
        }
    }
}

