/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.IWireSyncManager;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.NetHandlerCapability;
import blusunrize.immersiveengineering.api.wires.NetworkSanitizer;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.localhandlers.ILocalHandlerProvider;
import blusunrize.immersiveengineering.api.wires.localhandlers.IWorldTickable;
import blusunrize.immersiveengineering.api.wires.proxy.IICProxyProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class GlobalWireNetwork
implements IWorldTickable {
    public static final SetRestrictedField<BooleanSupplier> SANITIZE_CONNECTIONS = SetRestrictedField.common();
    public static final SetRestrictedField<BooleanSupplier> VALIDATE_CONNECTIONS = SetRestrictedField.common();
    private static WeakReference<Level> lastServerWorld = new WeakReference<Object>(null);
    private static WeakReference<GlobalWireNetwork> lastServerNet = new WeakReference<Object>(null);
    private static WeakReference<Level> lastClientWorld = new WeakReference<Object>(null);
    private static WeakReference<GlobalWireNetwork> lastClientNet = new WeakReference<Object>(null);
    private final Map<ConnectionPoint, LocalWireNetwork> localNetsByPos = new HashMap<ConnectionPoint, LocalWireNetwork>();
    private final Set<LocalWireNetwork> localNetSet = new ReferenceOpenHashSet();
    private final WireCollisionData collisionData;
    private final IICProxyProvider proxyProvider;
    private final IWireSyncManager syncManager;
    private Map<Pair<BlockPos, Level>, IImmersiveConnectable> queuedLoads = new LinkedHashMap<Pair<BlockPos, Level>, IImmersiveConnectable>();
    private boolean processingLoadQueue = false;
    private boolean validateNextTick = false;
    boolean validating = false;

    @Nonnull
    public static GlobalWireNetwork getNetwork(Level w) {
        GlobalWireNetwork lastNet;
        if (!w.f_46443_ && w == lastServerWorld.get() ? (lastNet = (GlobalWireNetwork)lastServerNet.get()) != null : w.f_46443_ && w == lastClientWorld.get() && (lastNet = (GlobalWireNetwork)lastClientNet.get()) != null) {
            return lastNet;
        }
        LazyOptional netOptional = w.getCapability(NetHandlerCapability.NET_CAPABILITY);
        if (!netOptional.isPresent()) {
            throw new RuntimeException("No net handler found for dimension " + w.m_46472_().m_135782_() + ", client: " + w.f_46443_);
        }
        GlobalWireNetwork ret = (GlobalWireNetwork)netOptional.orElseThrow(RuntimeException::new);
        if (!w.f_46443_) {
            lastServerWorld = new WeakReference<Level>(w);
            lastServerNet = new WeakReference<GlobalWireNetwork>(ret);
        } else {
            lastClientWorld = new WeakReference<Level>(w);
            lastClientNet = new WeakReference<GlobalWireNetwork>(ret);
        }
        return ret;
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload ev) {
        if (ev.getLevel() == lastServerWorld) {
            lastServerNet = null;
            lastServerWorld = null;
        }
    }

    public GlobalWireNetwork(boolean isClientSide, IICProxyProvider proxyProvider, IWireSyncManager syncManager) {
        this.proxyProvider = proxyProvider;
        this.collisionData = new WireCollisionData(this, isClientSide);
        this.syncManager = syncManager;
    }

    public void addConnection(Connection conn) {
        LocalWireNetwork joined;
        this.processQueuedLoads();
        ConnectionPoint posA = conn.getEndA();
        ConnectionPoint posB = conn.getEndB();
        LocalWireNetwork netA = this.getLocalNet(posA);
        LocalWireNetwork netB = this.getLocalNet(posB);
        if (netA != netB) {
            joined = netA.merge(netB, () -> new LocalWireNetwork(this));
            for (ConnectionPoint p : joined.getConnectionPoints()) {
                this.putLocalNet(p, joined);
            }
        } else {
            joined = netA;
        }
        joined.addConnection(conn, this);
        this.syncManager.onConnectionAdded(conn);
        this.collisionData.addConnection(conn);
        this.validateNextTick = true;
    }

    public void removeAllConnectionsAt(IImmersiveConnectable iic, Consumer<Connection> handler) {
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            this.removeAllConnectionsAt(cp, handler);
        }
    }

    public void removeAllConnectionsAt(ConnectionPoint pos, Consumer<Connection> handler) {
        this.processQueuedLoads();
        LocalWireNetwork net = this.getLocalNet(pos);
        ArrayList<Connection> conns = new ArrayList<Connection>(net.getConnections(pos));
        for (Connection conn : conns) {
            handler.accept(conn);
            this.removeConnection(conn);
        }
        this.validateNextTick = true;
    }

    public void removeConnection(Connection c) {
        this.processQueuedLoads();
        this.collisionData.removeConnection(c);
        LocalWireNetwork oldNet = this.getNullableLocalNet(c.getEndA());
        if (oldNet == null) {
            Preconditions.checkState((this.getNullableLocalNet(c.getEndB()) == null ? 1 : 0) != 0, (String)"Found net at %s but not at %s while removing connection %s", (Object)c.getEndB(), (Object)c.getEndA(), (Object)c);
            return;
        }
        Preconditions.checkNotNull((Object)oldNet.getConnector(c.getEndB()), (String)"Removing connection %s from net %s, but does not have connector for %s", (Object)c, (Object)oldNet, (Object)c.getEndB());
        oldNet.removeConnection(c);
        this.splitNet(oldNet);
        this.syncManager.onConnectionRemoved(c);
    }

    public void removeAndDropConnection(Connection c, BlockPos dropAt, Level world) {
        this.removeConnection(c);
        double dx = (double)dropAt.m_123341_() + 0.5;
        double dy = (double)dropAt.m_123342_() + 0.5;
        double dz = (double)dropAt.m_123343_() + 0.5;
        if (world.m_46469_().m_46207_(GameRules.f_46136_)) {
            world.m_7967_((Entity)new ItemEntity(world, dx, dy, dz, c.type.getWireCoil(c)));
        }
    }

    private void splitNet(LocalWireNetwork oldNet) {
        Collection<LocalWireNetwork> newNets = oldNet.split(this);
        for (LocalWireNetwork net : newNets) {
            for (ConnectionPoint p : net.getConnectionPoints()) {
                this.putLocalNet(p, net);
            }
        }
    }

    public void readFromNBT(CompoundTag nbt) {
        this.localNetSet.forEach(LocalWireNetwork::setInvalid);
        this.localNetSet.clear();
        this.localNetsByPos.clear();
        ListTag locals = nbt.m_128437_("locals", 10);
        for (Tag b : locals) {
            CompoundTag subnet = (CompoundTag)b;
            LocalWireNetwork localNet = new LocalWireNetwork(subnet, this);
            WireLogger.logger.info("Loading net {}", (Object)localNet);
            for (ConnectionPoint p : localNet.getConnectionPoints()) {
                this.putLocalNet(p, localNet);
            }
        }
        this.queuedLoads.clear();
    }

    public CompoundTag writeToNBT() {
        CompoundTag ret = new CompoundTag();
        ListTag locals = new ListTag();
        for (LocalWireNetwork local : this.localNetSet) {
            locals.add((Object)local.writeToNBT());
        }
        ret.m_128365_("locals", (Tag)locals);
        return ret;
    }

    public LocalWireNetwork getLocalNet(BlockPos pos) {
        return this.getLocalNet(new ConnectionPoint(pos, 0));
    }

    public LocalWireNetwork getLocalNet(ConnectionPoint pos) {
        this.processQueuedLoads();
        LocalWireNetwork ret = this.localNetsByPos.computeIfAbsent(pos, p -> {
            LocalWireNetwork newNet = new LocalWireNetwork(this);
            IImmersiveConnectable proxy = this.proxyProvider.create(pos.position(), (Collection<Connection>)ImmutableList.of(), (Collection<ConnectionPoint>)ImmutableList.of());
            newNet.addConnector(pos, proxy, this);
            this.localNetSet.add(newNet);
            return newNet;
        });
        Preconditions.checkState((boolean)ret.isValid(pos), (String)"%s is not a valid net", (Object)ret);
        return ret;
    }

    public LocalWireNetwork getNullableLocalNet(BlockPos pos) {
        return this.getNullableLocalNet(new ConnectionPoint(pos, 0));
    }

    public LocalWireNetwork getNullableLocalNet(ConnectionPoint pos) {
        this.processQueuedLoads();
        LocalWireNetwork ret = this.localNetsByPos.get(pos);
        if (ret != null) {
            Preconditions.checkState((boolean)ret.isValid(pos), (String)"%s is not valid for position %s", (Object)ret, (Object)pos);
        }
        return ret;
    }

    public void removeConnector(IImmersiveConnectable iic) {
        this.processQueuedLoads();
        WireLogger.logger.info("Removing connector {} at {}", (Object)iic, (Object)iic.getPosition());
        ObjectArraySet netsToRemoveFrom = new ObjectArraySet();
        BlockPos iicPos = iic.getPosition();
        for (ConnectionPoint c : iic.getConnectionPoints()) {
            LocalWireNetwork local = this.getNullableLocalNet(c);
            if (local == null) continue;
            this.putLocalNet(c, null);
            netsToRemoveFrom.add(local);
        }
        for (LocalWireNetwork net : netsToRemoveFrom) {
            net.removeConnector(iicPos);
            if (net.getConnectionPoints().isEmpty()) {
                this.localNetSet.remove(net);
                continue;
            }
            this.splitNet(net);
        }
        this.validateNextTick = true;
    }

    @VisibleForTesting
    public void onConnectorLoad(IImmersiveConnectable iic, boolean remote) {
        boolean isNew = false;
        HashSet<LocalWireNetwork> loadedInNets = new HashSet<LocalWireNetwork>();
        for (ConnectionPoint connectionPoint : iic.getConnectionPoints()) {
            LocalWireNetwork local;
            if (this.getNullableLocalNet(connectionPoint) == null) {
                isNew = true;
            }
            if (!loadedInNets.add(local = this.getLocalNet(connectionPoint))) continue;
            local.loadConnector(connectionPoint.position(), iic, false, this);
        }
        if (isNew && !remote) {
            for (Connection connection : iic.getInternalConnections()) {
                Preconditions.checkArgument((boolean)connection.isInternal(), (Object)("Internal connection for " + iic + "was not marked as internal!"));
                this.addConnection(connection);
            }
        }
    }

    public void onConnectorLoad(IImmersiveConnectable iic, Level world) {
        this.queuedLoads.put((Pair<BlockPos, Level>)Pair.of((Object)iic.getPosition(), (Object)world), iic);
    }

    private void processQueuedLoads() {
        if (this.queuedLoads.isEmpty() || this.processingLoadQueue) {
            return;
        }
        this.processingLoadQueue = true;
        try {
            this.processQueuedLoadsInner();
        }
        finally {
            this.processingLoadQueue = false;
        }
    }

    private void processQueuedLoadsInner() {
        Map<Pair<BlockPos, Level>, IImmersiveConnectable> toProcess = this.queuedLoads;
        this.queuedLoads = new LinkedHashMap<Pair<BlockPos, Level>, IImmersiveConnectable>();
        for (Map.Entry<Pair<BlockPos, Level>, IImmersiveConnectable> load : toProcess.entrySet()) {
            IImmersiveConnectable iic = load.getValue();
            Level level = (Level)load.getKey().getSecond();
            if (SafeChunkUtils.isChunkSafe((LevelAccessor)level, (BlockPos)load.getKey().getFirst())) {
                WireLogger.logger.info("Loading connector {} at {}", (Object)iic, (Object)iic.getPosition());
                if (this.validating) {
                    WireLogger.logger.error("Adding a connector during validation!");
                }
                this.onConnectorLoad(iic, level.f_46443_);
                ApiUtils.addFutureServerTask(level, () -> this.initializeConnectionsOn(iic, level), true);
                this.validateNextTick = true;
                if (!level.f_46443_) continue;
                this.updateModelData(iic, level);
                continue;
            }
            this.queuedLoads.put(load.getKey(), load.getValue());
        }
    }

    private void updateModelData(IImmersiveConnectable iic, Level world) {
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            LocalWireNetwork localNet = this.getLocalNet(cp);
            for (Connection c : this.getLocalNet(cp).getConnections(cp)) {
                ConnectionPoint otherEnd = c.getOtherEnd(cp);
                IImmersiveConnectable otherIIC = localNet.getConnector(otherEnd);
                if (otherIIC instanceof BlockEntity) {
                    ((BlockEntity)otherIIC).requestModelDataUpdate();
                }
                BlockState state = world.m_8055_(otherEnd.position());
                world.m_7260_(otherEnd.position(), state, state, 3);
            }
            BlockState state = world.m_8055_(cp.position());
            world.m_7260_(cp.position(), state, state, 3);
        }
        if (iic instanceof BlockEntity) {
            ((BlockEntity)iic).requestModelDataUpdate();
        }
    }

    private void initializeConnectionsOn(IImmersiveConnectable iic, Level world) {
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            for (Connection c : this.getLocalNet(cp).getConnections(cp)) {
                IImmersiveConnectable iicEnd;
                ConnectionPoint otherEnd = c.getOtherEnd(cp);
                LocalWireNetwork otherLocal = this.getNullableLocalNet(otherEnd);
                if (otherLocal == null || (iicEnd = otherLocal.getConnector(otherEnd)).isProxy()) continue;
                WireLogger.logger.info("Here: {}, other end: {}", (Object)iic, (Object)iicEnd);
                this.collisionData.addConnection(c);
            }
        }
    }

    public void onConnectorUnload(IImmersiveConnectable iic) {
        BlockPos pos = iic.getPosition();
        this.processQueuedLoads();
        WireLogger.logger.info("Unloading connector {} at {}", (Object)iic, (Object)iic.getPosition());
        HashMap<LocalWireNetwork, Boolean> handledNets = new HashMap<LocalWireNetwork, Boolean>();
        for (ConnectionPoint connectionPoint : iic.getConnectionPoints()) {
            LocalWireNetwork local = this.getLocalNet(connectionPoint);
            Boolean actuallyRemoved = (Boolean)handledNets.get(local);
            if (actuallyRemoved == null) {
                actuallyRemoved = local.unloadConnector(pos, iic);
                handledNets.put(local, actuallyRemoved);
            }
            if (!actuallyRemoved.booleanValue()) continue;
            for (Connection c : local.getConnections(connectionPoint)) {
                this.collisionData.removeConnection(c);
            }
        }
        this.validateNextTick = true;
    }

    @Override
    public void update(Level world) {
        if (this.validateNextTick) {
            this.validate(world);
            this.validateNextTick = false;
        }
        this.processQueuedLoads();
        if (world.m_5776_()) {
            return;
        }
        for (LocalWireNetwork net : (LocalWireNetwork[])this.localNetSet.toArray(LocalWireNetwork[]::new)) {
            net.update(world);
        }
        if (SANITIZE_CONNECTIONS.getValue().getAsBoolean()) {
            NetworkSanitizer.tick((LevelAccessor)world, this);
        }
    }

    private void validate(Level world) {
        if (world.f_46443_ || !VALIDATE_CONNECTIONS.getValue().getAsBoolean()) {
            return;
        }
        WireLogger.logger.info("Validating wire network...");
        if (this.validating) {
            WireLogger.logger.error("Recursive validation call!");
            Thread.dumpStack();
        }
        this.validating = true;
        this.localNetsByPos.values().stream().distinct().forEach(local -> {
            HashMap handlerUsers = new HashMap();
            Function<ResourceLocation, Multiset> getHandler = rl -> handlerUsers.computeIfAbsent(rl, r -> HashMultiset.create());
            for (ConnectionPoint cp : local.getConnectionPoints()) {
                IImmersiveConnectable iic = local.getConnector(cp);
                if (!iic.getConnectionPoints().contains(cp)) {
                    WireLogger.logger.warn("Connection point {} does not exist on {}", (Object)cp, (Object)iic);
                    continue;
                }
                for (ResourceLocation rl2 : iic.getRequestedHandlers()) {
                    getHandler.apply(rl2).add((Object)iic);
                }
                if (this.localNetsByPos.get(cp) != local) {
                    WireLogger.logger.warn("{} has net {}, but is in net {}", (Object)cp, (Object)this.localNetsByPos.get(cp), local);
                    continue;
                }
                for (Connection c : local.getConnections(cp)) {
                    if (this.localNetsByPos.get(c.getOtherEnd(cp)) != local) {
                        WireLogger.logger.warn("{} is connected to {}, but nets are {} and {}", (Object)cp, (Object)c.getOtherEnd(cp), (Object)this.localNetsByPos.get(c.getOtherEnd(cp)), local);
                    } else if (!local.getConnections(c.getOtherEnd(cp)).contains(c)) {
                        WireLogger.logger.warn("Connection {} from {} to {} is a diode!", (Object)c, (Object)cp, (Object)c.getOtherEnd(cp));
                    }
                    if (!c.isPositiveEnd(cp)) continue;
                    for (ResourceLocation rl3 : c.type.getRequestedHandlers()) {
                        getHandler.apply(rl3).add((Object)c.type);
                    }
                }
            }
            for (ResourceLocation rl4 : handlerUsers.keySet()) {
                Multiset expected;
                Multiset<ILocalHandlerProvider> actual = local.handlerUsers.get(rl4);
                if (actual.equals((Object)(expected = (Multiset)handlerUsers.get(rl4)))) continue;
                WireLogger.logger.warn("Expected users for {}: {}, but found {}", (Object)rl4, (Object)expected, (Object)actual);
            }
            for (ResourceLocation rl4 : local.handlerUsers.keySet()) {
                if (handlerUsers.containsKey(rl4)) continue;
                WireLogger.logger.warn("Found no users for {}, but net expects {}", (Object)rl4, (Object)local.handlerUsers.get(rl4));
            }
            for (BlockPos p : local.getConnectors()) {
                BlockEntity inWorld;
                IImmersiveConnectable inNet;
                if (!SafeChunkUtils.isChunkSafe((LevelAccessor)world, p) || (inNet = local.getConnector(p)) == (inWorld = SafeChunkUtils.getSafeBE((LevelAccessor)world, p))) continue;
                WireLogger.logger.warn("Connector at {}: {} in Net, {} in World (Net is {})", (Object)p, (Object)inNet, (Object)inWorld, local);
            }
        });
        ReferenceOpenHashSet actualLocalSet = new ReferenceOpenHashSet(this.localNetsByPos.values());
        actualLocalSet.removeIf(lwn -> !lwn.isValid());
        if (!this.localNetSet.equals(actualLocalSet)) {
            WireLogger.logger.warn("Local net set does not match value set of local nets by position");
            WireLogger.logger.warn("Actual set, but not in stored set: {}", (Object)new HashSet(Sets.difference((Set)actualLocalSet, this.localNetSet)));
            WireLogger.logger.warn("Stored set, but not in actual set: {}", (Object)new HashSet(Sets.difference(this.localNetSet, (Set)actualLocalSet)));
        }
        WireLogger.logger.info("Validated!");
        this.validating = false;
    }

    public WireCollisionData getCollisionData() {
        return this.collisionData;
    }

    public Collection<ConnectionPoint> getAllConnectorsIn(ChunkPos pos) {
        ArrayList<ConnectionPoint> ret = new ArrayList<ConnectionPoint>();
        for (ConnectionPoint cp : this.localNetsByPos.keySet()) {
            if (!pos.equals((Object)new ChunkPos(cp.position()))) continue;
            ret.add(cp);
        }
        return ret;
    }

    void removeCP(ConnectionPoint cp) {
        LocalWireNetwork local = this.getNullableLocalNet(cp);
        if (local != null) {
            local.removeCP(cp);
        }
    }

    void removeConnector(BlockPos pos) {
        ArrayList<ConnectionPoint> cpsAtInvalid = new ArrayList<ConnectionPoint>();
        for (ConnectionPoint cp : this.localNetsByPos.keySet()) {
            if (!cp.position().equals((Object)pos)) continue;
            cpsAtInvalid.add(cp);
        }
        for (ConnectionPoint toRemove : cpsAtInvalid) {
            this.removeCP(toRemove);
        }
    }

    public void updateCatenaryData(Connection conn) {
        this.processQueuedLoads();
        this.collisionData.removeConnection(conn);
        LocalWireNetwork local = this.getLocalNet(conn.getEndA());
        IImmersiveConnectable iicA = local.getConnector(conn.getEndA());
        IImmersiveConnectable iicB = local.getConnector(conn.getEndB());
        Vec3 newOffsetA = iicA.getConnectionOffset(conn.getEndA(), conn.getEndB(), conn.type);
        Vec3 newOffsetB = iicB.getConnectionOffset(conn.getEndB(), conn.getEndA(), conn.type);
        conn.resetCatenaryData(newOffsetA, newOffsetB);
        this.collisionData.addConnection(conn);
        this.syncManager.onConnectionEndpointsChanged(conn);
    }

    private void putLocalNet(ConnectionPoint cp, @Nullable LocalWireNetwork net) {
        LocalWireNetwork oldNet = this.localNetsByPos.get(cp);
        if (oldNet != null && net != null && oldNet.isValid(cp)) {
            WireLogger.logger.info("Marking {} as invalid", (Object)oldNet);
            oldNet.setInvalid();
            this.localNetSet.remove(oldNet);
        }
        if (net != null) {
            this.localNetsByPos.put(cp, net);
            this.localNetSet.add(net);
        } else {
            this.localNetsByPos.remove(cp);
        }
    }

    public IImmersiveConnectable getExistingConnector(ConnectionPoint cp) {
        LocalWireNetwork local = this.getNullableLocalNet(cp);
        return ((LocalWireNetwork)Preconditions.checkNotNull((Object)local, (String)"No local net at %s", (Object)cp)).getConnector(cp);
    }

    public IICProxyProvider getProxyProvider() {
        return this.proxyProvider;
    }
}

