/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.MetalPressLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public class MetalPressRenderer
extends IEBlockEntityRenderer<MultiblockBlockEntityMaster<MetalPressLogic.State>> {
    public static final String NAME = "metal_press_piston";
    public static DynamicModel PISTON;

    public void render(MultiblockBlockEntityMaster<MetalPressLogic.State> te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IMultiblockBEHelper helper = te.getHelper();
        MetalPressLogic.State state = (MetalPressLogic.State)helper.getState();
        float piston = 0.0f;
        float[] shift = new float[state.processor.getQueueSize()];
        for (int i = 0; i < shift.length; ++i) {
            MultiblockProcess<MetalPressRecipe, ProcessContext.ProcessContextInWorld<MetalPressRecipe>> process = state.processor.getQueue().get(i);
            float processMaxTicks = process.getMaxTicks(te.m_58904_());
            float transportTime = MetalPressLogic.getTransportTime(processMaxTicks);
            float pressTime = MetalPressLogic.getPressTime(processMaxTicks);
            float fProcess = process.processTick;
            shift[i] = fProcess < transportTime ? 0.5f * fProcess / transportTime : (fProcess < processMaxTicks - transportTime ? 0.5f : 0.5f + 0.5f * (fProcess - (processMaxTicks - transportTime)) / transportTime);
            if (state.mold.m_41619_() || !(fProcess >= transportTime) || !(fProcess < processMaxTicks - transportTime)) continue;
            piston = fProcess < transportTime + pressTime ? (fProcess - transportTime) / pressTime : (fProcess < processMaxTicks - transportTime - pressTime ? 1.0f : 1.0f - (fProcess - (processMaxTicks - transportTime - pressTime)) / pressTime);
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        MultiblockOrientation orientation = helper.getContext().getLevel().getOrientation();
        Direction effectiveFacing = orientation.mirrored() ? orientation.front().m_122424_() : orientation.front();
        MetalPressRenderer.rotateForFacingNoCentering(matrixStack, effectiveFacing);
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, -piston * 0.6875f, 0.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BakedModel pistonModel = PISTON.get();
        blockRenderer.m_110937_().renderModel(matrixStack.m_85850_(), bufferIn.m_6299_(RenderType.m_110451_()), null, pistonModel, 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, RenderType.m_110451_());
        matrixStack.m_85849_();
        if (!state.mold.m_41619_()) {
            matrixStack.m_85837_(0.0, 0.34, 0.0);
            matrixStack.m_252781_(new Quaternionf().rotateX(-1.5707964f));
            float scale = 0.75f;
            matrixStack.m_85841_(scale, scale, 1.0f);
            ClientUtils.mc().m_91291_().m_269128_(state.mold, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, te.m_58904_(), 0);
        }
        matrixStack.m_85849_();
        bufferIn = BERenderUtils.mirror(helper.getContext().getLevel().getOrientation(), matrixStack, bufferIn);
        matrixStack.m_85837_(-1.25, -0.35, 0.0);
        for (int i = 0; i < shift.length; ++i) {
            MultiblockProcessInWorld inWorld;
            List<ItemStack> displays;
            MultiblockProcess<MetalPressRecipe, ProcessContext.ProcessContextInWorld<MetalPressRecipe>> process = state.processor.getQueue().get(i);
            if (!(process instanceof MultiblockProcessInWorld) || (displays = (inWorld = (MultiblockProcessInWorld)process).getDisplayItem(te.m_58904_())).isEmpty()) continue;
            matrixStack.m_85836_();
            matrixStack.m_252880_(2.5f * shift[i], 0.0f, 0.0f);
            if ((double)piston > 0.92) {
                matrixStack.m_85837_(0.0, 0.92 - (double)piston, 0.0);
            }
            matrixStack.m_252781_(new Quaternionf().rotateX(-1.5707964f));
            float scale = 0.625f;
            matrixStack.m_85841_(scale, scale, 1.0f);
            ClientUtils.mc().m_91291_().m_269128_(displays.get(0), ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, te.m_58904_(), 0);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }
}

