/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingInsertionHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.BottlingMachineShapes;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BottlingMachineLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final float TRANSLATION_DISTANCE = 2.5f;
    private static final float STANDARD_TRANSPORT_TIME = 20.0f;
    private static final float STANDARD_LIFT_TIME = 3.75f;
    private static final float MIN_CYCLE_TIME = 60.0f;
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(3, 1, 1, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition ITEM_INPUT_POS = new CapabilityPosition(0, 1, 1, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition FLUID_INPUT_POS_BACK = new CapabilityPosition(0, 0, 0, RelativeBlockFace.FRONT);
    private static final CapabilityPosition FLUID_INPUT_POS_SIDE = new CapabilityPosition(0, 0, 0, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition ENERGY_INPUT_POS = new CapabilityPosition(2, 1, 0, RelativeBlockFace.UP);
    public static final BlockPos REDSTONE_POS = new BlockPos(1, 0, 1);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        boolean active;
        State state = context.getState();
        state.active = active = state.processor.tickServer(state, context.getLevel(), state.rsState.isEnabled(context));
        if (active) {
            context.requestMasterBESync();
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.active) {
            return;
        }
        IMultiblockLevel level = context.getLevel();
        Level rawLevel = level.getRawLevel();
        for (MultiblockProcess process : state.processor.getQueue()) {
            float fProcess = process.processTick;
            Player localPlayer = ImmersiveEngineering.proxy.getClientPlayer();
            if (!(fProcess >= 7.0f) || !(fProcess < 9.0f)) continue;
            BlockPos soundPos = level.toAbsolute(new BlockPos(1, 1, 1));
            rawLevel.m_5594_(localPlayer, soundPos, (SoundEvent)IESounds.bottling.get(), SoundSource.BLOCKS, 0.125f, 0.8f);
            break;
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void onEntityCollision(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Entity collided) {
        BottlingProcess process;
        NonNullList<ItemStack> displayStacks;
        Level level = collided.m_9236_();
        if (!new BlockPos(0, 1, 1).equals((Object)posInMultiblock) || level.f_46443_) {
            return;
        }
        if (!(collided instanceof ItemEntity) || !collided.m_6084_()) {
            return;
        }
        State state = ctx.getState();
        BlockPos absoluteCollisionPos = ctx.getLevel().toAbsolute(posInMultiblock);
        List<Pair> itemsOnConveyor = level.m_45976_(ItemEntity.class, AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)absoluteCollisionPos))).stream().map(itemEntity1 -> Pair.of((Object)itemEntity1, (Object)itemEntity1.m_32055_())).toList();
        if (itemsOnConveyor.isEmpty()) {
            return;
        }
        ItemStack[] stacks = (ItemStack[])itemsOnConveyor.stream().map(Pair::getSecond).toArray(ItemStack[]::new);
        BottlingMachineRecipe recipe = BottlingMachineRecipe.findRecipe(level, state.tank.getFluid(), stacks);
        if (recipe == null && !Utils.isFluidRelatedItemStack(stacks[0])) {
            return;
        }
        if (recipe == null) {
            ItemStack inputItem = ItemHandlerHelper.copyStackWithSize((ItemStack)stacks[0], (int)1);
            displayStacks = Utils.createNonNullItemStackListFromItemStack(stacks[0]);
            process = new BottlingProcess(inputItem, inputItem.m_41777_(), state);
        } else {
            displayStacks = recipe.getDisplayStacks(stacks);
            process = new BottlingProcess(recipe, displayStacks, state);
        }
        if (state.processor.addProcessToQueue(process, level, false)) {
            for (ItemStack stack : displayStacks) {
                itemsOnConveyor.stream().filter(t -> ItemStack.m_150942_((ItemStack)((ItemStack)t.getSecond()), (ItemStack)stack)).findFirst().ifPresent(t -> {
                    ItemStack remaining = ((ItemStack)t.getSecond()).m_41777_();
                    remaining.m_41774_(stack.m_41613_());
                    ((ItemEntity)t.getFirst()).m_32045_(remaining);
                    if (remaining.m_41619_()) {
                        ((ItemEntity)t.getFirst()).m_146870_();
                    }
                });
            }
        }
    }

    @Override
    public InteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        if (!player.m_21120_(hand).m_204117_(IETags.hammers)) {
            return InteractionResult.PASS;
        }
        if (!isClient) {
            State state = ctx.getState();
            state.allowPartialFill = !state.allowPartialFill;
            player.m_5661_((Component)Component.m_237115_((String)("chat.immersiveengineering.info.bottling_machine." + (state.allowPartialFill ? "partialFill" : "completeFill"))), true);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && ITEM_INPUT_POS.equals(position)) {
            return ctx.getState().itemInput.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && (FLUID_INPUT_POS_BACK.equalsOrNullFace(position) || FLUID_INPUT_POS_SIDE.equals(position))) {
            return ctx.getState().fluidInput.cast(ctx);
        }
        if (cap == ForgeCapabilities.ENERGY && ENERGY_INPUT_POS.equalsOrNullFace(position)) {
            return ctx.getState().energyInput.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        for (MultiblockProcess process : state.processor.getQueue()) {
            if (!(process instanceof BottlingProcess)) continue;
            BottlingProcess bottlingProcess = (BottlingProcess)process;
            bottlingProcess.inputItems.forEach(drop);
        }
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return BottlingMachineShapes.SHAPE_GETTER;
    }

    public static float getTransportTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 20.0f;
        }
        return processMaxTicks * 20.0f / 60.0f;
    }

    public static float getLiftTime(float processMaxTicks) {
        if (processMaxTicks >= 60.0f) {
            return 3.75f;
        }
        return processMaxTicks * 3.75f / 60.0f;
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInWorld<BottlingMachineRecipe> {
        public final MultiblockProcessor.InWorldProcessor<BottlingMachineRecipe> processor;
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        public final FluidTank tank = new FluidTank(8000);
        boolean allowPartialFill;
        public boolean active;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final DroppingMultiblockOutput output;
        private final StoredCapability<IItemHandler> itemInput;
        private final StoredCapability<IFluidHandler> fluidInput;
        private final StoredCapability<IEnergyStorage> energyInput;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            Runnable sync = ctx.getSyncRunnable();
            this.processor = new MultiblockProcessor.InWorldProcessor<BottlingMachineRecipe>(2, maxTicks -> 1.0f - (BottlingMachineLogic.getTransportTime(maxTicks) + BottlingMachineLogic.getLiftTime(maxTicks)) / (float)maxTicks, 2, markDirty, sync, BottlingMachineRecipe.RECIPES::getById);
            this.output = new DroppingMultiblockOutput(OUTPUT_POS, ctx);
            this.itemInput = new StoredCapability<BottlingInsertionHandler>(new BottlingInsertionHandler(ctx.levelSupplier(), this.processor, this));
            this.fluidInput = new StoredCapability<ArrayFluidHandler>(new ArrayFluidHandler((IFluidTank)this.tank, false, true, () -> {
                markDirty.run();
                sync.run();
            }));
            this.energyInput = new StoredCapability<AveragingEnergyStorage>(this.energy);
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128379_("allowPartialFill", this.allowPartialFill);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.processor.fromNBT(nbt.m_128423_("processor"), BottlingProcess.loader(this));
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.allowPartialFill = nbt.m_128471_("allowPartialFill");
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128379_("active", this.active);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.processor.fromNBT(nbt.m_128423_("processor"), BottlingProcess.loader(this));
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.active = nbt.m_128471_("active");
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public void doProcessOutput(ItemStack result, IMultiblockLevel level) {
            this.output.insertOrDrop(result, level);
        }
    }
}

