/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.AutoWorkbenchLogic;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class AutoWorkbenchMenu
extends IEContainerMenu {
    public final EnergyStorage energyStorage;
    public final GetterAndSetter<Integer> selectedRecipe;

    public static AutoWorkbenchMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, IEContainerMenu.MultiblockMenuContext<AutoWorkbenchLogic.State> ctx) {
        AutoWorkbenchLogic.State state = ctx.mbContext().getState();
        return new AutoWorkbenchMenu(AutoWorkbenchMenu.multiblockCtx(type, id, ctx), invPlayer, (IItemHandler)state.inventory, state.getEnergy(), new GetterAndSetter<Integer>(() -> state.selectedRecipe, i -> {
            state.selectedRecipe = i;
        }));
    }

    public static AutoWorkbenchMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new AutoWorkbenchMenu(AutoWorkbenchMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(17), new MutableEnergyStorage(32000), GetterAndSetter.standalone(0));
    }

    private AutoWorkbenchMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler inv, MutableEnergyStorage energyStorage, GetterAndSetter<Integer> selectedRecipe) {
        super(ctx);
        this.energyStorage = energyStorage;
        this.selectedRecipe = selectedRecipe;
        this.m_38897_((Slot)new IESlot.AutoBlueprint(inv, 0, 102, 69));
        for (int i = 0; i < 16; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(inv, 1 + i, 7 + i % 4 * 18, 24 + i / 4 * 18));
        }
        this.ownSlotCount = 17;
        this.bindPlayerInv(inventoryPlayer);
        this.addGenericData(GenericContainerData.energy(energyStorage));
        this.addGenericData(new GenericContainerData<Integer>(GenericDataSerializers.INT32, selectedRecipe));
    }

    private void bindPlayerInv(Inventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 103 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 161));
        }
    }

    @Override
    @Nonnull
    public ItemStack m_7648_(Player player, int slot) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slotObject = (Slot)this.f_38839_.get(slot);
        if (slotObject != null && slotObject.m_6657_()) {
            ItemStack stackInSlot = slotObject.m_7993_();
            stack = stackInSlot.m_41777_();
            if (slot < this.ownSlotCount) {
                if (!this.m_38903_(stackInSlot, this.ownSlotCount, this.ownSlotCount + 36, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (!stackInSlot.m_41619_()) {
                if (stackInSlot.m_41720_() instanceof EngineersBlueprintItem) {
                    if (!this.m_38903_(stackInSlot, 0, 1, true)) {
                        return ItemStack.f_41583_;
                    }
                } else {
                    boolean b = true;
                    for (int i = 1; i < this.ownSlotCount; ++i) {
                        Slot s = (Slot)this.f_38839_.get(i);
                        if (s == null || !s.m_5857_(stackInSlot) || !this.m_38903_(stackInSlot, i, i + 1, true)) continue;
                        b = false;
                        break;
                    }
                    if (b) {
                        return ItemStack.f_41583_;
                    }
                }
            }
            if (stackInSlot.m_41613_() == 0) {
                slotObject.m_5852_(ItemStack.f_41583_);
            } else {
                slotObject.m_6654_();
            }
            if (stackInSlot.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slotObject.m_142406_(player, stack);
        }
        return stack;
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        if (nbt.m_128425_("recipe", 3)) {
            this.selectedRecipe.set(nbt.m_128451_("recipe"));
        }
    }
}

