/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.entities.CapabilitySkyhookData;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class SkyhookItem
extends UpgradeableToolItem {
    private static final String LIMIT_SPEED = "limitSpeed";

    public SkyhookItem() {
        super(new Item.Properties().m_41487_(1), "SKYHOOK");
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        if (SkyhookItem.shouldLimitSpeed(stack)) {
            list.add((Component)Component.m_237115_((String)"desc.immersiveengineering.flavour.skyhook.speedLimit"));
        } else {
            list.add((Component)Component.m_237115_((String)"desc.immersiveengineering.flavour.skyhook.noLimit"));
        }
        list.add((Component)Component.m_237115_((String)"desc.immersiveengineering.flavour.skyhook"));
    }

    public static boolean shouldLimitSpeed(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, LIMIT_SPEED);
    }

    public static void setLimitSpeed(ItemStack stack, boolean doLimit) {
        ItemNBTHelper.putBoolean(stack, LIMIT_SPEED, doLimit);
    }

    public static boolean toggleSpeedLimit(ItemStack stack) {
        CompoundTag nbt;
        boolean wasActive = (nbt = stack.m_41784_()).m_128471_(LIMIT_SPEED);
        nbt.m_128379_(LIMIT_SPEED, !wasActive);
        return !wasActive;
    }

    public void m_6883_(ItemStack stack, Level world, Entity ent, int slot, boolean inHand) {
        super.m_6883_(stack, world, ent, slot, inHand);
        if (this.getUpgrades(stack).m_128471_("fallBoost")) {
            float dmg = (float)Math.ceil(ent.f_19789_ / 5.0f);
            ItemNBTHelper.putFloat(stack, "fallDamageBoost", dmg);
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36335_().m_41519_((Item)this)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (player.m_6144_()) {
            boolean limitSpeed = SkyhookItem.toggleSpeedLimit(stack);
            if (limitSpeed) {
                player.m_5661_((Component)Component.m_237115_((String)"chat.immersiveengineering.info.skyhookLimited"), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"chat.immersiveengineering.info.skyhookUnlimited"), true);
            }
        } else {
            CapabilitySkyhookData.SkyhookUserData data = (CapabilitySkyhookData.SkyhookUserData)player.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, Direction.UP).orElseThrow(RuntimeException::new);
            if (data.hook != null && !world.f_46443_) {
                data.dismount();
                IELogger.logger.info("Player left voluntarily");
            } else {
                data.startHolding();
                player.m_6672_(hand);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int count) {
        super.m_5929_(level, player, stack, count);
        CapabilitySkyhookData.SkyhookUserData data = (CapabilitySkyhookData.SkyhookUserData)player.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, Direction.UP).orElseThrow(RuntimeException::new);
        if (data.getStatus() != CapabilitySkyhookData.SkyhookStatus.HOLDING_CONNECTING) {
            return;
        }
        Connection con = WireUtils.getConnectionMovedThrough(level, player);
        if (con != null) {
            SkylineHelper.spawnHook(player, con, player.m_7655_(), SkyhookItem.shouldLimitSpeed(stack));
        }
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity player, int timeLeft) {
        super.m_5551_(stack, worldIn, player, timeLeft);
        if (!worldIn.f_46443_) {
            player.getCapability(CapabilitySkyhookData.SKYHOOK_USER_DATA, Direction.UP).ifPresent(CapabilitySkyhookData.SkyhookUserData::release);
        }
    }

    public float getSkylineSpeed(ItemStack stack) {
        return 3.0f + this.getUpgrades(stack).m_128457_("speed");
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 0, 102, 42, "SKYHOOK", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 1, 102, 22, "SKYHOOK", stack, true, level, getPlayer)};
    }

    @Override
    public int getSlotCount() {
        return 2;
    }
}

