/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.cctweaked;

import blusunrize.immersiveengineering.common.util.compat.computers.cctweaked.CCLuaTypeConverter;
import blusunrize.immersiveengineering.common.util.compat.computers.cctweaked.GenericPeripheral;
import blusunrize.immersiveengineering.common.util.compat.computers.cctweaked.TaskCallback;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackEnvironment;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackOwner;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerCallback;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.EventWaiterResult;
import com.google.common.base.Preconditions;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PeripheralCreator<T extends BlockEntity> {
    private final List<ComputerCallback<? super T>> methods;
    private final String[] methodNames;
    private final CallbackOwner<T> owner;

    public PeripheralCreator(CallbackOwner<T> owner) throws IllegalAccessException {
        this.methods = ComputerCallback.getInClass(owner, CCLuaTypeConverter.INSTANCE, Function.identity());
        this.methodNames = (String[])this.methods.stream().map(ComputerCallback::getName).toArray(String[]::new);
        this.owner = owner;
    }

    @Nullable
    public GenericPeripheral<T> make(Object instanceObj) {
        Preconditions.checkArgument((boolean)this.owner.getCallbackType().isAssignableFrom(instanceObj.getClass()));
        BlockEntity instance = (BlockEntity)instanceObj;
        if (this.owner.canAttachTo(instance)) {
            return new GenericPeripheral<BlockEntity>(this, instance);
        }
        return null;
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    public MethodResult call(IComputerAccess computerAccess, ILuaContext ctx, int index, IArguments otherArgs, T mainArgument) throws LuaException {
        ComputerCallback<T> callback = this.methods.get(index);
        if (callback.isAsync()) {
            Object[] result = this.callInner(callback, otherArgs, mainArgument);
            Object object = result[0];
            if (object instanceof EventWaiterResult) {
                EventWaiterResult eventResult = (EventWaiterResult)object;
                eventResult.startAsync(() -> computerAccess.queueEvent(eventResult.name(), new Object[0]));
                return MethodResult.pullEvent((String)eventResult.name(), args -> MethodResult.of());
            }
            return MethodResult.of((Object[])result);
        }
        return TaskCallback.make(ctx, () -> this.callInner(callback, otherArgs, mainArgument));
    }

    private Object[] callInner(ComputerCallback<? super T> callback, IArguments otherArgs, T mainArgument) throws LuaException {
        try {
            return callback.invoke(otherArgs.getAll(), new CallbackEnvironment<T>(this.owner.preprocess(mainArgument), mainArgument.m_58904_()));
        }
        catch (RuntimeException x) {
            throw new LuaException(x.getMessage());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException("Unexpected error, check server log!");
        }
    }

    public String getName() {
        return this.owner.getName();
    }
}

