/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.links;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.links.Link;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class EntryWithLinks {
    private final List<Either<String, Link>> tokens;

    public EntryWithLinks(String entryText, ManualInstance manual) {
        List<String> rawTokens = EntryWithLinks.splitWhitespace(entryText);
        ArrayList<Either> tokens = new ArrayList<Either>(rawTokens.size());
        for (String token : rawTokens) {
            if (token.startsWith("<link") && token.charAt(token.length() - 1) == '>') {
                String[] segment = token.substring(0, token.length() - 1).split(";");
                if (segment.length < 3) break;
                String target = segment[1];
                String anchor = segment.length > 3 ? segment[3] : "start";
                String text = segment[2];
                Link link = new Link(text, target, anchor, manual);
                tokens.add(Either.right((Object)link));
                continue;
            }
            tokens.add(Either.left((Object)token));
        }
        this.tokens = ImmutableList.copyOf(tokens);
    }

    @Deprecated
    public List<Link> getLinks() {
        return this.tokens.stream().map(e -> e.right()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Deprecated
    public String getSanitizedText() {
        return this.tokens.stream().map(e -> (String)e.map(s -> s, l -> String.join((CharSequence)"", l.getParts()))).collect(Collectors.joining());
    }

    public List<Either<String, Link>> getUnsplitTokens() {
        return this.tokens;
    }

    public static List<String> splitWhitespace(String in) {
        ArrayList<String> parts = new ArrayList<String>();
        int i = 0;
        while (i < in.length()) {
            StringBuilder here = new StringBuilder();
            char first = in.charAt(i);
            here.append(first);
            ++i;
            while (i < in.length()) {
                char hereC = in.charAt(i);
                byte action = EntryWithLinks.shouldSplit(first, hereC);
                if ((action & 1) != 0) {
                    here.append(in.charAt(i));
                    ++i;
                }
                if ((action & 2) == 0 && (action & 1) != 0) continue;
                break;
            }
            parts.add(here.toString());
        }
        return parts;
    }

    private static byte shouldSplit(char start, char here) {
        int ret = 1;
        if (Character.isWhitespace(start) ^ Character.isWhitespace(here)) {
            ret = 2;
        } else if (Character.isWhitespace(here)) {
            if (start == '\n' && here == '\r' || start == '\r' && here == '\n') {
                ret = 3;
            } else if (here == '\r' || here == '\n' || start == '\r' || start == '\n') {
                ret = 2;
            }
        }
        if (here == '<') {
            ret = 2;
        }
        if (start == '<') {
            ret = 1;
            if (here == '>') {
                ret = (byte)(ret | 2);
            }
        }
        return (byte)ret;
    }
}

