/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe.generic;

import com.blamejared.crafttweaker.api.action.recipe.generic.ActionRemoveGenericRecipeBase;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.item.crafting.Recipe;

public class ActionRemoveGenericRecipe
extends ActionRemoveGenericRecipeBase {
    protected final Predicate<Recipe<?>> removePredicate;
    protected Supplier<String> describeFunction;

    public ActionRemoveGenericRecipe(Predicate<Recipe<?>> removePredicate) {
        this.removePredicate = removePredicate;
        this.describeFunction = () -> "Removing all recipes that match a custom condition";
    }

    public ActionRemoveGenericRecipe(Predicate<Recipe<?>> removePredicate, Supplier<String> describeFunction) {
        this.removePredicate = removePredicate;
        this.describeFunction = describeFunction;
    }

    @Override
    public String describe() {
        return this.describeFunction.get();
    }

    @Override
    protected boolean shouldRemove(Recipe<?> recipe) {
        return this.removePredicate.test(recipe);
    }
}

