/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.event.bus;

import com.blamejared.crafttweaker.api.event.bus.BusHandlingException;
import com.blamejared.crafttweaker.api.event.bus.IEventDispatcher;
import com.blamejared.crafttweaker.api.event.bus.IHandlerToken;
import com.blamejared.crafttweaker.api.util.GenericUtil;

final class ArrayBackedDispatcher<T> {
    private static final IEventDispatcher<Object> UNREGISTERED = it -> {};
    private IEventDispatcher<T>[] dispatchers = (IEventDispatcher[])GenericUtil.uncheck(new IEventDispatcher[0]);

    ArrayBackedDispatcher() {
    }

    public IHandlerToken<T> register(IEventDispatcher<T> dispatcher) {
        IHandlerToken<T> token = this.doRegister(dispatcher, false);
        if (token != null) {
            return token;
        }
        this.grow();
        return this.doRegister(dispatcher, true);
    }

    public void unregister(IHandlerToken<T> token) {
        IEventDispatcher newConsumer;
        if (!(token instanceof ArrayHandlerToken)) {
            throw new IllegalArgumentException("Invalid token object for dispatcher");
        }
        ArrayHandlerToken arrayToken = (ArrayHandlerToken)token;
        int position = arrayToken.index();
        int next = position + 1;
        this.dispatchers[position] = newConsumer = next == this.dispatchers.length || this.dispatchers[next] == null ? null : (IEventDispatcher)GenericUtil.uncheck(UNREGISTERED);
        if (newConsumer == null) {
            for (int i = position - 1; i >= 0 && this.dispatchers[i] == UNREGISTERED; --i) {
                this.dispatchers[i] = null;
            }
        }
        arrayToken.invalidate();
    }

    public void dispatch(T event) {
        for (IEventDispatcher<T> dispatcher : this.dispatchers) {
            if (dispatcher == null) break;
            dispatcher.dispatch(event);
        }
    }

    private IHandlerToken<T> doRegister(IEventDispatcher<T> dispatcher, boolean exception) {
        int s = this.dispatchers.length;
        for (int i = 0; i < s; ++i) {
            if (this.dispatchers[i] != null && this.dispatchers[i] != UNREGISTERED) continue;
            this.dispatchers[i] = new CatchingDispatcher<T>(dispatcher);
            return ArrayHandlerToken.of(i);
        }
        if (exception) {
            throw new IllegalStateException("Unable to register handler");
        }
        return null;
    }

    private void grow() {
        int length = this.dispatchers.length;
        IEventDispatcher[] replacement = (IEventDispatcher[])GenericUtil.uncheck(new IEventDispatcher[length * 3 / 2 + 1]);
        System.arraycopy(this.dispatchers, 0, replacement, 0, length);
        this.dispatchers = replacement;
    }

    private static final class ArrayHandlerToken<T>
    implements IHandlerToken<T> {
        private final int index;
        private boolean valid;

        private ArrayHandlerToken(int index) {
            this.index = index;
            this.valid = true;
        }

        static <T> ArrayHandlerToken<T> of(int index) {
            return new ArrayHandlerToken<T>(index);
        }

        int index() {
            this.valid();
            return this.index;
        }

        void invalidate() {
            this.valid = false;
        }

        private void valid() {
            if (!this.valid) {
                throw new IllegalStateException("Token has been invalidated");
            }
        }
    }

    private record CatchingDispatcher<T>(IEventDispatcher<T> dispatcher) implements IEventDispatcher<T>
    {
        @Override
        public void dispatch(T event) {
            try {
                this.dispatcher().dispatch(event);
            }
            catch (Exception e) {
                throw new BusHandlingException(e);
            }
        }
    }
}

