/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.fluid;

import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

public class MCFluidStackMutable
implements IFluidStack {
    private final FluidStack stack;

    public MCFluidStackMutable(FluidStack stack) {
        this.stack = stack;
    }

    @Override
    public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @Override
    public long getAmount() {
        return this.getInternal().getAmount();
    }

    @Override
    public IFluidStack setAmount(int amount) {
        this.getInternal().setAmount(amount);
        return this;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public Fluid getFluid() {
        return this.getInternal().getFluid();
    }

    @Override
    public IFluidStack withTag(IData tag) {
        if (tag != null) {
            MapData map = new MapData(tag.asMap());
            this.getInternal().setTag(map.getInternal());
        } else {
            this.getInternal().setTag(null);
        }
        return this;
    }

    @Override
    public boolean hasTag() {
        return this.getInternal().hasTag();
    }

    @Override
    public CompoundTag getInternalTag() {
        return this.getInternal().getTag();
    }

    @Override
    public IData getTag() {
        return TagToDataConverter.convert((Tag)this.getInternal().getTag());
    }

    public FluidStack getInternal() {
        return this.stack;
    }

    public FluidStack getImmutableInternal() {
        return this.stack.copy();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidStack thatStack = ((MCFluidStackMutable)o).getInternal();
        FluidStack thisStack = this.getInternal();
        if (thisStack.isEmpty()) {
            return thatStack.isEmpty();
        }
        if (thisStack.getAmount() != thatStack.getAmount()) {
            return false;
        }
        if (!Objects.equals(thisStack.getFluid(), thatStack.getFluid())) {
            return false;
        }
        return Objects.equals(thisStack.getTag(), thatStack.getTag());
    }

    public int hashCode() {
        return Objects.hash(this.getInternal().getAmount(), this.getInternal().getFluid(), this.getInternal().getTag());
    }
}

