/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.replacement.type;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.DescriptivePredicate;
import com.blamejared.crafttweaker.api.recipe.replacement.IFilteringRule;
import com.blamejared.crafttweaker.api.recipe.replacement.ITargetingStrategy;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="vanilla/api/recipe/replacement/type/ComponentFilteringRule")
@ZenCodeType.Name(value="crafttweaker.api.recipe.replacement.type.ComponentFilteringRule")
@ZenRegister
public final class ComponentFilteringRule<T>
implements IFilteringRule {
    private final IRecipeComponent<T> component;
    private final DescriptivePredicate<T> thing;
    private final ITargetingStrategy checkStrategy;

    private ComponentFilteringRule(IRecipeComponent<T> component, DescriptivePredicate<T> thing, ITargetingStrategy checkStrategy) {
        this.component = component;
        this.thing = thing;
        this.checkStrategy = checkStrategy;
    }

    @ZenCodeType.Method
    public static <T> ComponentFilteringRule<T> of(IRecipeComponent<T> component) {
        return ComponentFilteringRule.of(component, null);
    }

    @ZenCodeType.Method
    public static <T> ComponentFilteringRule<T> of(IRecipeComponent<T> component, T content) {
        return ComponentFilteringRule.of(component, content, ITargetingStrategy.find(ITargetingStrategy.DEFAULT_STRATEGY_ID));
    }

    @ZenCodeType.Method
    public static <T> ComponentFilteringRule<T> of(IRecipeComponent<T> component, T content, ITargetingStrategy checkStrategy) {
        DescriptivePredicate<Object> predicate = content == null ? null : DescriptivePredicate.of((T it) -> component.match(content, it), content.toString());
        return new ComponentFilteringRule<Object>(component, predicate, checkStrategy);
    }

    @ZenCodeType.Method
    public static <T> ComponentFilteringRule<T> of(IRecipeComponent<T> component, Predicate<T> content, ITargetingStrategy checkStrategy) {
        return new ComponentFilteringRule<T>(component, content == null ? null : DescriptivePredicate.wrap(content), checkStrategy);
    }

    @Override
    public Stream<? extends Recipe<?>> castFilter(Stream<? extends Recipe<?>> allRecipes) {
        return allRecipes.filter(this::castFilter);
    }

    @Override
    public String describe() {
        return "recipes with component %s%s".formatted(this.component.getCommandString(), this.thing == null ? "" : " matching %s according to strategy %s".formatted(this.thing.describe(), this.checkStrategy.getCommandString()));
    }

    private <C extends Container, V extends Recipe<C>> boolean castFilter(V recipe) {
        IRecipeManager manager;
        IRecipeHandler<V> handler = CraftTweakerAPI.getRegistry().getRecipeHandlerFor(recipe);
        Optional<IDecomposedRecipe> decomposedRecipe = handler.decompose(manager = (IRecipeManager)GenericUtil.uncheck(RecipeTypeBracketHandler.getOrDefault(recipe.m_6671_())), recipe);
        return decomposedRecipe.isPresent() && this.castFilter(decomposedRecipe.get());
    }

    private boolean castFilter(IDecomposedRecipe recipe) {
        return this.thing != null ? this.castFullFilter(recipe) : this.castBasicFilter(recipe);
    }

    private boolean castFullFilter(IDecomposedRecipe recipe) {
        return this.castBasicFilter(recipe) && this.castComponentFilter(recipe);
    }

    private boolean castBasicFilter(IDecomposedRecipe recipe) {
        return recipe.components().contains(this.component);
    }

    private boolean castComponentFilter(IDecomposedRecipe recipe) {
        List<T> component = recipe.get(this.component);
        for (T element : component) {
            Object result = this.checkStrategy.castStrategy(this.component, element, this::fakeReplacement);
            if (result == null) continue;
            return true;
        }
        return false;
    }

    private T fakeReplacement(T element) {
        return (T)(this.thing.test(element) ? element : null);
    }
}

