/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.helper.inventory;

import com.blamejared.crafttweaker.platform.helper.inventory.IInventoryWrapper;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class IItemHandlerWrapper
implements IInventoryWrapper {
    private final IItemHandler handler;

    public IItemHandlerWrapper(IItemHandler handler) {
        this.handler = handler;
    }

    @Override
    public int getContainerSize() {
        return this.handler.getSlots();
    }

    @Override
    @Nonnull
    public ItemStack getItem(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    @Override
    public boolean canFitInSlot(int slot, ItemStack stack) {
        ItemStack item = this.getItem(slot);
        if (item.m_41619_()) {
            return true;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)stack)) {
            int maxStackSize = Math.min(this.handler.getSlotLimit(slot), item.m_41741_());
            return item.m_41613_() + stack.m_41613_() < maxStackSize;
        }
        return false;
    }

    @Override
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot >= 0 && slot < this.handler.getSlots()) {
            return this.handler.insertItem(slot, stack, simulate);
        }
        return stack;
    }
}

