/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.vertex;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import me.jellysquid.mods.sodium.mixin.core.render.VertexFormatAccessor;
import net.caffeinemc.mods.sodium.api.vertex.attributes.CommonVertexAttribute;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;

public class VertexFormatDescriptionImpl
implements VertexFormatDescription {
    @Deprecated
    private final VertexFormat format;
    private final int id;
    private final int stride;
    private final int[] offsets;

    public VertexFormatDescriptionImpl(VertexFormat format, int id) {
        this.format = format;
        this.id = id;
        this.stride = format.m_86020_();
        this.offsets = VertexFormatDescriptionImpl.getOffsets(format);
    }

    public static int[] getOffsets(VertexFormat format) {
        int[] commonElementOffsets = new int[CommonVertexAttribute.COUNT];
        Arrays.fill(commonElementOffsets, -1);
        ImmutableList elementList = format.m_86023_();
        IntList elementOffsets = ((VertexFormatAccessor)format).getOffsets();
        for (int elementIndex = 0; elementIndex < elementList.size(); ++elementIndex) {
            VertexFormatElement element = (VertexFormatElement)elementList.get(elementIndex);
            CommonVertexAttribute commonType = CommonVertexAttribute.getCommonType(element);
            if (commonType == null) continue;
            commonElementOffsets[commonType.ordinal()] = elementOffsets.getInt(elementIndex);
        }
        return commonElementOffsets;
    }

    @Override
    public boolean containsElement(CommonVertexAttribute element) {
        return this.offsets[element.ordinal()] != -1;
    }

    @Override
    public int getElementOffset(CommonVertexAttribute element) {
        int offset = this.offsets[element.ordinal()];
        if (offset == -1) {
            throw new NoSuchElementException("Vertex format does not contain element: " + element);
        }
        return offset;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int stride() {
        return this.stride;
    }

    @Deprecated
    public VertexFormat format() {
        return this.format;
    }
}

