/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.datastructure;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;

public class CompositeMap<K, V>
implements Map<K, V> {
    private final List<Map<K, V>> elements = Lists.newArrayList();

    public void addElement(Map<K, V> element) {
        this.elements.add(Collections.unmodifiableMap(element));
    }

    public boolean removeElement(Map<K, V> element) {
        return this.elements.remove(element);
    }

    public void resetElements() {
        this.elements.clear();
    }

    @Override
    public int size() {
        int size = 0;
        for (Map<K, V> element : this.elements) {
            size += element.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (Map<K, V> element : this.elements) {
            if (element.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Map<K, V> element : this.elements) {
            if (!element.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map<K, V> element : this.elements) {
            if (!element.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        for (Map<K, V> element : this.elements) {
            V value = element.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        throw new NotImplementedException("Adding elements in a composite map view is not supported");
    }

    @Override
    public V remove(Object key) {
        throw new NotImplementedException("Removing elements in a composite map view is not supported");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new NotImplementedException("Adding elements in a composite map view is not supported");
    }

    @Override
    public void clear() {
        throw new NotImplementedException("Clearing elements in a composite map view is not supported");
    }

    @Override
    public Set<K> keySet() {
        HashSet keys = Sets.newHashSet();
        for (Map<K, V> element : this.elements) {
            keys.addAll(element.keySet());
        }
        return keys;
    }

    @Override
    public Collection<V> values() {
        LinkedList values = Lists.newLinkedList();
        for (Map<K, V> element : this.elements) {
            values.addAll(element.values());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet entries = Sets.newHashSet();
        for (Map<K, V> element : this.elements) {
            entries.addAll(element.entrySet());
        }
        return entries;
    }
}

