/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionLike;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionLikeSingleClassifiedTrait;

public class FilteredIngredientCollectionLikeSingleClassifiedIterator<T, M, I, C, L extends IIngredientCollectionLike<T, M, I>>
implements Iterator<I> {
    private final IIngredientCollectionLikeSingleClassifiedTrait<T, M, I, C, L> classifiedCollection;
    private final Iterator<I> iterator;
    private final IIngredientMatcher<T, M> matcher;
    private final T instance;
    private final M matchCondition;
    private I next;

    public FilteredIngredientCollectionLikeSingleClassifiedIterator(IIngredientCollectionLikeSingleClassifiedTrait<T, M, I, C, L> classifiedCollection, IIngredientMatcher<T, M> matcher, T instance, M matchCondition) {
        this.classifiedCollection = classifiedCollection;
        this.iterator = this.classifiedCollection.iterator();
        this.matcher = matcher;
        this.instance = instance;
        this.matchCondition = matchCondition;
        this.next = null;
    }

    protected I findNext() {
        while (this.iterator.hasNext()) {
            I next = this.iterator.next();
            if (!this.matcher.matches(this.instance, this.classifiedCollection.getInstance(next), this.matchCondition)) continue;
            return next;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.next = this.findNext();
        }
        return this.next != null;
    }

    @Override
    public I next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Tried reading a finished FilteredIngredientMapIterator");
        }
        I next = this.next;
        this.next = null;
        return next;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

