/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.lib;

import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.entity.player.Player;

public class AbilityCache {
    private static final HashMap<String, Runnable> EMPTY_MAP = new HashMap();
    private final Map<String, Map<String, Runnable>> cache = new HashMap<String, Map<String, Runnable>>();

    public void add(Augment augment, Player player, Runnable onRemove) {
        this.add(augment.getId().toString(), player, onRemove);
    }

    public void add(String augment, Player player, Runnable onRemove) {
        String key = AbilityCache.getPlayerKey(player);
        this.cache.computeIfAbsent(augment, s -> new HashMap()).put(key, onRemove);
    }

    public void remove(Augment augment, Player player) {
        this.remove(augment.getId().toString(), player);
    }

    public void remove(String augment, Player player) {
        String key = AbilityCache.getPlayerKey(player);
        ((Runnable)((Map)this.cache.getOrDefault(augment, EMPTY_MAP)).remove(key)).run();
    }

    public void removeQuietly(Augment augment, Player player) {
        this.removeQuietly(augment.getId().toString(), player);
    }

    public void removeQuietly(String augment, Player player) {
        String key = AbilityCache.getPlayerKey(player);
        ((Map)this.cache.getOrDefault(augment, EMPTY_MAP)).remove(key);
    }

    public boolean isCached(Augment augment, Player player) {
        return this.isCached(augment.getId().toString(), player);
    }

    public boolean isCached(String augment, Player player) {
        String key = AbilityCache.getPlayerKey(player);
        return ((Map)this.cache.getOrDefault(augment, EMPTY_MAP)).containsKey(key);
    }

    public Set<String> getCachedAbilities(Player player) {
        String key = AbilityCache.getPlayerKey(player);
        return this.cache.entrySet().stream().filter(e -> ((Map)e.getValue()).containsKey(key)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static String getPlayerKey(Player player) {
        return player.m_36316_().getName() + ":" + player.m_9236_().m_5776_();
    }
}

