/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class AwakeningRecipe
implements ISpecialRecipe,
IAwakeningRecipe {
    public static final int RECIPE_SIZE = 9;
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final NonNullList<ItemStack> essences;
    private final ItemStack output;
    private final boolean transferNBT;

    public AwakeningRecipe(ResourceLocation recipeId, NonNullList<Ingredient> inputs, NonNullList<ItemStack> essences, ItemStack output, boolean transferNBT) {
        this.recipeId = recipeId;
        this.essences = essences;
        this.output = output;
        this.transferNBT = transferNBT;
        NonNullList allInputs = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        allInputs.set(0, (Object)((Ingredient)inputs.get(0)));
        allInputs.set(1, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{(ItemStack)essences.get(0)}));
        allInputs.set(2, (Object)((Ingredient)inputs.get(1)));
        allInputs.set(3, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{(ItemStack)essences.get(1)}));
        allInputs.set(4, (Object)((Ingredient)inputs.get(2)));
        allInputs.set(5, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{(ItemStack)essences.get(2)}));
        allInputs.set(6, (Object)((Ingredient)inputs.get(3)));
        allInputs.set(7, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{(ItemStack)essences.get(3)}));
        allInputs.set(8, (Object)((Ingredient)inputs.get(4)));
        this.inputs = allInputs;
    }

    public ItemStack assemble(IItemHandler inventory, RegistryAccess access) {
        CompoundTag tag;
        ItemStack stack = inventory.getStackInSlot(0);
        ItemStack result = this.output.m_41777_();
        if (this.transferNBT && (tag = stack.m_41783_()) != null) {
            result.m_41751_(tag.m_6426_());
            return result;
        }
        return result;
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess access) {
        return this.assemble((IItemHandler)new InvWrapper(inventory), access);
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.AWAKENING.get();
    }

    public RecipeType<? extends IAwakeningRecipe> m_6671_() {
        return (RecipeType)ModRecipeTypes.AWAKENING.get();
    }

    public boolean matches(IItemHandler inventory) {
        ItemStack altarStack = inventory.getStackInSlot(0);
        return !this.inputs.isEmpty() && ((Ingredient)this.inputs.get(0)).test(altarStack) && super.matches(inventory);
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    public NonNullList<ItemStack> getRemainingItems(IItemHandler inventory) {
        NonNullList remaining = NonNullList.m_122780_((int)inventory.getSlots(), (Object)ItemStack.f_41583_);
        block0: for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (i > 0 && i % 2 == 0) {
                Ingredient ingredient = (Ingredient)this.inputs.get(i - 1);
                if (ingredient.m_43947_()) continue;
                for (ItemStack essence : this.essences) {
                    if (ingredient.m_43908_()[0] != essence) continue;
                    remaining.set(i, (Object)StackHelper.shrink((ItemStack)stack, (int)essence.m_41613_(), (boolean)false));
                    continue block0;
                }
                continue;
            }
            if (!stack.hasCraftingRemainingItem()) continue;
            remaining.set(i, (Object)stack.getCraftingRemainingItem());
        }
        return remaining;
    }

    @Override
    public NonNullList<ItemStack> getEssences() {
        return this.essences;
    }

    @Override
    public Map<ItemStack, Integer> getMissingEssences(List<ItemStack> items) {
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>((Collection<ItemStack>)this.essences);
        LinkedHashMap<ItemStack, Integer> missing = new LinkedHashMap<ItemStack, Integer>();
        block0: for (ItemStack item : items) {
            for (ItemStack essence : remaining) {
                int required;
                if (!ItemStack.m_150942_((ItemStack)item, (ItemStack)essence)) continue;
                int current = item.m_41613_();
                if (current < (required = essence.m_41613_())) {
                    missing.put(essence, required - current);
                }
                remaining.remove(essence);
                continue block0;
            }
        }
        for (ItemStack essence : remaining) {
            missing.put(essence, essence.m_41613_());
        }
        return missing;
    }

    public static class Serializer
    implements RecipeSerializer<AwakeningRecipe> {
        public AwakeningRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.m_122780_((int)5, (Object)Ingredient.f_43901_);
            JsonObject input = GsonHelper.m_13930_((JsonObject)json, (String)"input");
            inputs.set(0, (Object)Ingredient.m_43917_((JsonElement)input));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i + 1, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            NonNullList essences = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
            JsonArray essenceArray = GsonHelper.m_13933_((JsonObject)json, (String)"essences");
            for (int i = 0; i < essenceArray.size(); ++i) {
                essences.set(i, (Object)ShapedRecipe.m_151274_((JsonObject)essenceArray.get(i).getAsJsonObject()));
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("result"));
            boolean transferNBT = GsonHelper.m_13855_((JsonObject)json, (String)"transfer_nbt", (boolean)false);
            return new AwakeningRecipe(recipeId, (NonNullList<Ingredient>)inputs, (NonNullList<ItemStack>)essences, result, transferNBT);
        }

        public AwakeningRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            size = buffer.m_130242_();
            NonNullList essences = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
            for (int i = 0; i < size; ++i) {
                essences.set(i, (Object)buffer.m_130267_());
            }
            ItemStack output = buffer.m_130267_();
            boolean transferNBT = buffer.readBoolean();
            return new AwakeningRecipe(recipeId, (NonNullList<Ingredient>)inputs, (NonNullList<ItemStack>)essences, output, transferNBT);
        }

        public void toNetwork(FriendlyByteBuf buffer, AwakeningRecipe recipe) {
            int i;
            buffer.m_130130_(5);
            for (i = 0; i <= 8; i += 2) {
                ((Ingredient)recipe.inputs.get(i)).m_43923_(buffer);
            }
            buffer.m_130130_(4);
            for (i = 0; i < 4; ++i) {
                buffer.m_130055_((ItemStack)recipe.essences.get(i));
            }
            buffer.m_130055_(recipe.output);
            buffer.writeBoolean(recipe.transferNBT);
        }
    }
}

