/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.MultiblockPositions;
import com.blakebr0.mysticalagriculture.api.crafting.IInfusionRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.tileentity.InfusionPedestalTileEntity;
import com.blakebr0.mysticalagriculture.util.IActivatable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class InfusionAltarTileEntity
extends BaseInventoryTileEntity
implements IActivatable {
    private final BaseItemStackHandler inventory;
    private final BaseItemStackHandler recipeInventory;
    private final MultiblockPositions pedestalLocations = new MultiblockPositions.Builder().pos(3, 0, 0).pos(0, 0, 3).pos(-3, 0, 0).pos(0, 0, -3).pos(2, 0, 2).pos(2, 0, -2).pos(-2, 0, 2).pos(-2, 0, -2).build();
    private final CachedRecipe<IInfusionRecipe> recipe;
    private int progress;
    private boolean active;

    public InfusionAltarTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.INFUSION_ALTAR.get(), pos, state);
        this.inventory = InfusionAltarTileEntity.createInventoryHandler(() -> ((InfusionAltarTileEntity)this).setChangedFast());
        this.recipeInventory = BaseItemStackHandler.create((int)9);
        this.recipe = new CachedRecipe((RecipeType)ModRecipeTypes.INFUSION.get());
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.active = tag.m_128471_("Active");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128379_("Active", this.active);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean isActive() {
        if (!this.active) {
            this.active = this.f_58857_ != null && this.f_58857_.m_276867_(this.m_58899_());
        }
        return this.active;
    }

    @Override
    public void activate() {
        this.active = true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, InfusionAltarTileEntity tile) {
        ItemStack input = tile.inventory.getStackInSlot(0);
        if (input.m_41619_()) {
            tile.reset();
            return;
        }
        if (tile.isActive()) {
            IInfusionRecipe recipe = tile.getActiveRecipe();
            if (recipe != null) {
                ++tile.progress;
                List<InfusionPedestalTileEntity> pedestals = tile.getPedestals();
                if (tile.progress >= 100) {
                    NonNullList remaining = recipe.m_7457_((Container)tile.recipeInventory.asRecipeWrapper());
                    for (int i = 0; i < pedestals.size(); ++i) {
                        InfusionPedestalTileEntity pedestal = pedestals.get(i);
                        pedestal.getInventory().setStackInSlot(0, (ItemStack)remaining.get(i + 1));
                        tile.spawnParticles(ParticleTypes.f_123762_, pedestal.m_58899_(), 1.2, 20);
                    }
                    ItemStack result = recipe.m_5874_((Container)tile.recipeInventory.asRecipeWrapper(), level.m_9598_());
                    tile.setOutput(result);
                    tile.reset();
                    tile.setChangedFast();
                    tile.spawnParticles(ParticleTypes.f_123748_, pos, 1.0, 10);
                } else {
                    for (InfusionPedestalTileEntity pedestal : pedestals) {
                        BlockPos pedestalPos = pedestal.m_58899_();
                        ItemStack stack = pedestal.getInventory().getStackInSlot(0);
                        tile.spawnItemParticles(pedestalPos, stack);
                    }
                }
            } else {
                tile.reset();
            }
        } else {
            tile.progress = 0;
        }
        tile.dispatchIfChanged();
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        return BaseItemStackHandler.create((int)2, (Runnable)onContentsChanged, builder -> {
            builder.setDefaultSlotLimit(1);
            builder.setCanInsert((slot, stack) -> builder.getStackInSlot(1).m_41619_());
            builder.setOutputSlots(new int[]{1});
        });
    }

    public List<BlockPos> getPedestalPositions() {
        return this.pedestalLocations.get(this.m_58899_());
    }

    public IInfusionRecipe getActiveRecipe() {
        if (this.f_58857_ == null) {
            return null;
        }
        this.updateRecipeInventory(this.getPedestals());
        return (IInfusionRecipe)this.recipe.checkAndGet(this.recipeInventory, this.f_58857_);
    }

    private void reset() {
        this.progress = 0;
        this.active = false;
    }

    private void updateRecipeInventory(List<InfusionPedestalTileEntity> pedestals) {
        this.recipeInventory.setSize(9);
        this.recipeInventory.setStackInSlot(0, this.inventory.getStackInSlot(0));
        for (int i = 0; i < pedestals.size(); ++i) {
            ItemStack stack = pedestals.get(i).getInventory().getStackInSlot(0);
            this.recipeInventory.setStackInSlot(i + 1, stack);
        }
    }

    private List<InfusionPedestalTileEntity> getPedestals() {
        if (this.f_58857_ == null) {
            return Collections.emptyList();
        }
        ArrayList<InfusionPedestalTileEntity> pedestals = new ArrayList<InfusionPedestalTileEntity>();
        for (BlockPos pos : this.getPedestalPositions()) {
            BlockEntity tile = this.f_58857_.m_7702_(pos);
            if (!(tile instanceof InfusionPedestalTileEntity)) continue;
            InfusionPedestalTileEntity pedestal = (InfusionPedestalTileEntity)tile;
            pedestals.add(pedestal);
        }
        return pedestals;
    }

    private <T extends ParticleOptions> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.f_58857_;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + yOffset;
        double z = (double)pos.m_123343_() + 0.5;
        level.m_8767_(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    private void spawnItemParticles(BlockPos pedestalPos, ItemStack stack) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_() || stack.m_41619_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.f_58857_;
        BlockPos pos = this.m_58899_();
        double x = (double)pedestalPos.m_123341_() + level.m_213780_().m_188500_() * 0.2 + 0.4;
        double y = (double)pedestalPos.m_123342_() + level.m_213780_().m_188500_() * 0.2 + 1.2;
        double z = (double)pedestalPos.m_123343_() + level.m_213780_().m_188500_() * 0.2 + 0.4;
        double velX = pos.m_123341_() - pedestalPos.m_123341_();
        double velY = 0.25;
        double velZ = pos.m_123343_() - pedestalPos.m_123343_();
        level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), x, y, z, 0, velX, velY, velZ, 0.18);
    }

    private void setOutput(ItemStack stack) {
        NonNullList stacks = this.inventory.getStacks();
        stacks.set(0, (Object)ItemStack.f_41583_);
        stacks.set(1, (Object)stack);
    }
}

